package itez.core.wrapper.render;

import com.jfinal.render.Render;
import com.jfinal.render.RenderFactory;

public class ERenderFactory extends RenderFactory {
	
	@Override
	public Render getRender(String view) {
		ERender render = new ERender(view);
		return render;
	}

	@Override
	public Render getJsonRender() {
		return new EJsonRender();
	}

	@Override
	public Render getJsonRender(String key, Object value) {
		return new EJsonRender(key, value);
	}

	@Override
	public Render getJsonRender(String[] attrs) {
		return new EJsonRender(attrs);
	}

	@Override
	public Render getJsonRender(String jsonText) {
		return new EJsonRender(jsonText);
	}

	@Override
	public Render getJsonRender(Object object) {
		return new EJsonRender(object);
	}
	
}
