package itez.core.wrapper.render;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import itez.kit.EDate;
import itez.kit.ELog;

public class ERenderControl implements IRenderControl {

	private Long startDate;
	
	public void renderBefore(String view, HttpServletRequest request, HttpServletResponse response) {
		startDate = EDate.getTime();
	}

	public void renderAfter(String view, HttpServletRequest request, HttpServletResponse response) {
		ELog.info("完成渲染视图（{}ms）：{} ", EDate.getTime() - startDate, view);
	}

}