package itez.core.wrapper.render;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import com.jfinal.render.RenderException;
import com.jfinal.render.TemplateRender;
import com.jfinal.template.Engine;

public class ERender extends TemplateRender {

	private IRenderControl renderControl = new ERenderControl();
	private Engine customEngine = null;

	public ERender(String view) {
		super(view);
	}

	public ERender(Engine engine, String view) {
		super(view);
		this.customEngine = engine;
	}

	@Override
	public void render() {
		response.setContentType(getContentType());
		Map<Object, Object> data = new HashMap<Object, Object>();
		for (Enumeration<String> attrs = request.getAttributeNames(); attrs.hasMoreElements();) {
			String attrName = attrs.nextElement();
			data.put(attrName, request.getAttribute(attrName));
		}
		try {
			if(null != this.renderControl) renderControl.renderBefore(view, request, response);
			OutputStream os = response.getOutputStream();
			if(customEngine != null)
				customEngine.getTemplate(view).render(data, os);
			else
				engine.getTemplate(view).render(data, os);
		} catch (RuntimeException e) {	// 捕获 ByteWriter.close() 抛出的 RuntimeException
			Throwable cause = e.getCause();
			if (cause instanceof IOException) {	// ClientAbortException、EofException 直接或间接继承自 IOException
				String name = cause.getClass().getSimpleName();
				if ("ClientAbortException".equals(name) || "EofException".equals(name)) {
					return ;
				}
			}
			throw e;
		} catch (IOException e) {
			throw new RenderException(e);
		}finally{
			if(null != this.renderControl) renderControl.renderAfter(view, request, response);
		}
	}

}
