package itez.core.wrapper.render;

import java.io.IOException;
import java.io.PrintWriter;
import com.jfinal.render.JsonRender;
import com.jfinal.render.RenderException;

public class EJsonRender extends JsonRender {

	public EJsonRender() {
		super();
	}

	public EJsonRender(String key, Object value) {
		super(key, value);
	}

	public EJsonRender(String[] attrs) {
		super(attrs);
	}

	public EJsonRender(String jsonText) {
		super(jsonText);
	}

	public EJsonRender(Object object) {
		super(object);
	}

	@Override
	public void render() {
		if (jsonText == null) {
			buildJsonText();
		}
		PrintWriter writer = null;
		try {
			response.setHeader("Pragma", "no-cache");	// HTTP/1.0 caches might not implement Cache-Control and might only implement Pragma: no-cache
			response.setHeader("Cache-Control", "no-cache");
			response.setDateHeader("Expires", 0);
			response.setContentType(forIE ? contentTypeForIE : contentType);
			writer = response.getWriter();
			writer.write(jsonText);
			// writer.flush();
		} catch (IOException e) {
			throw new RenderException(e);
		}
	}
	
}
