package itez.core.wrapper.dbo.plugin;

import itez.core.runtime.EContext;
import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect.DbType;

import java.util.Properties;

import javax.sql.DataSource;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.jfinal.plugin.druid.DruidPlugin;

public class EDruidPlugin extends DruidPlugin {

	private DbType dbType = DbType.mysql;
	private boolean useInformationSchema = false;
	private boolean useFilterStat = false;
	private boolean useFilterWall = false;
	private boolean isStarted = false;
	
	public EDruidPlugin(DbProp prop){
		super(prop.getJdbcUrl(), prop.getUserName(), prop.getPassWord(), prop.getDriverClass());
		
		this.dbType = prop.getType();
		this.useFilterStat = false;
		this.useFilterWall = false;
		this.setFilter();
		
		int initialSize = prop.getInitialSize();
		int minIdle = prop.getMinIdle();
		int maxActive = prop.getMaxActive();
		super.set(initialSize, minIdle, maxActive);
	}
	
	public EDruidPlugin(DbProp prop, boolean useInformationSchema){
		super(prop.getJdbcUrl(), prop.getUserName(), prop.getPassWord(), prop.getDriverClass());
		
		this.dbType = prop.getType();
		this.useFilterStat = false;
		this.useFilterWall = false;
		this.setFilter();
		
		int initialSize = prop.getInitialSize();
		int minIdle = prop.getMinIdle();
		int maxActive = prop.getMaxActive();
		super.set(initialSize, minIdle, maxActive);
		
		this.setUseInformationSchema(useInformationSchema);
	}
	
	public EDruidPlugin(String url, String username, String password, String driverClass) {
		super(url, username, password, driverClass);
	}

	public EDruidPlugin(String url, String username, String password, String driverClass, DbType dbType, boolean useFilterStat, boolean useFilterWall) {
		super(url, username, password, driverClass);
		this.dbType = dbType;
		this.useFilterStat = useFilterStat;
		this.useFilterWall = useFilterWall;
		this.setFilter();
	}
	
	private void setFilter(){
		if(this.useFilterStat){ //启用监控统计过滤器
			StatFilter stat = new StatFilter();
			stat.setDbType(dbType.toString());
			addFilter(stat);
		}
		if(this.useFilterWall){ //启用防SQL注入过滤器
			WallConfig config = new WallConfig();
			config.setFunctionCheck(false); // 支持数据库函数
			WallFilter wall = new WallFilter();
			wall.setDbType(dbType.toString());
			wall.setConfig(config);
			addFilter(wall);
		}
//		DomainFilter domainFilter = new DomainFilter();
//		addFilter(domainFilter);
	}
	
	@Override
	public DataSource getDataSource() {
		DruidDataSource dataSource = (DruidDataSource)super.getDataSource();
		dataSource.setDbType(this.dbType.name());
		if(this.useInformationSchema){ //允许使用元数据库
			Properties properties = new Properties();
			properties.setProperty("remarks", "true");
			properties.setProperty("useInformationSchema", "true");
			dataSource.setConnectProperties(properties);
		}
		
		return dataSource;
	}
	
	@Override
	public boolean start() {
		try {
			super.start();
			isStarted = true;
		} catch (Exception e) {
			EContext.getController().setFlashMsg("数据库连接失败：" + e.getMessage());
			isStarted = false;
		}
		return isStarted;
	}
	
	@Override
	public boolean stop() {
		if(super.stop()) isStarted = false;
		return true;
	}

	public boolean isUseInformationSchema() {
		return useInformationSchema;
	}

	public void setUseInformationSchema(boolean useInformationSchema) {
		this.useInformationSchema = useInformationSchema;
	}

	public DbType getDbType() {
		return dbType;
	}

	public boolean isUseFilterStat() {
		return useFilterStat;
	}

	public boolean isUseFilterWall() {
		return useFilterWall;
	}

	public boolean isStarted() {
		return isStarted;
	}

}
