package itez.core.wrapper.dbo.plugin;

import javax.sql.DataSource;

import com.jfinal.plugin.activerecord.ActiveRecordPlugin;

import itez.core.runtime.EContext;

public class EActiveRecordPlugin extends ActiveRecordPlugin {
	
	private boolean isStarted = false;

	public EActiveRecordPlugin(String configName, DataSource dataSource) {
		super(configName, dataSource);
	}
	
	@Override
	public boolean start() {
		try {
			super.start();
			isStarted = true;
		} catch (Exception e) {
			EContext.getController().setFlashMsg("数据库连接失败：" + e.getMessage());
			isStarted = false;
		}
		return isStarted;
	}
	
	@Override
	public boolean stop() {
		if(super.stop()) isStarted = false;
		return true;
	}

}
