package itez.core.wrapper.dbo.model;

public class Selector {

	private Querys querys = null;
	private String groupBy = null;
	private String orderBy = null;
	private Object limit = null;
	private String[] columns = null;

	public Selector() {
	}
	
	public Selector(Query query) {
		this.querys = Querys.and(query);
	}
	
	public Selector(Querys querys) {
		this.querys = querys;
	}
	
	public Selector(Query query, String orderBy){
		this.querys = Querys.and(query);
		this.orderBy = orderBy;
	}
	
	public Selector(Querys querys, String orderBy){
		this.querys = querys;
		this.orderBy = orderBy;
	}
	
	public Selector(Query query, String orderBy, Object limit){
		this.querys = Querys.and(query);
		this.orderBy = orderBy;
		this.limit = limit;
	}
	
	public Selector(Querys querys, String orderBy, Object limit){
		this.querys = querys;
		this.orderBy = orderBy;
		this.limit = limit;
	}
	
	public Selector(Query query, String orderBy, Object limit, String...cols){
		this.querys = Querys.and(query);
		this.orderBy = orderBy;
		this.limit = limit;
		this.columns = cols;
	}
	
	public Selector(Querys querys, String orderBy, Object limit, String...cols){
		this.querys = querys;
		this.orderBy = orderBy;
		this.limit = limit;
		this.columns = cols;
	}
	
	public Selector(String...cols){
		this.columns = cols;
	}

	public Querys getQuerys() {
		return querys;
	}

	public Selector setQuerys(Querys querys) {
		this.querys = querys;
		return this;
	}
	
	public Selector where(Query query){
		return setQuerys(Querys.and(query));
	}
	
	public Selector where(Querys querys){
		return setQuerys(querys);
	}

	public String getGroupBy() {
		return groupBy;
	}

	public Selector setGroupBy(String groupBy) {
		this.groupBy = groupBy;
		return this;
	}
	
	public Selector groupBy(String groupBy){
		return setGroupBy(groupBy);
	}

	public String getOrderBy() {
		return orderBy;
	}

	public Selector setOrderBy(String orderBy) {
		this.orderBy = orderBy;
		return this;
	}
	
	public Selector orderBy(String orderBy){
		return setOrderBy(orderBy);
	}

	public Object getLimit() {
		return limit;
	}

	public Selector setLimit(Object limit) {
		this.limit = limit;
		return this;
	}

	public String[] getColumns() {
		return columns;
	}

	public Selector setColumns(String...columns) {
		this.columns = columns;
		return this;
	}

	public static Selector select() {
		return new Selector();
	}

	public static Selector select(String...columns) {
		return new Selector(columns);
	}
	
}
