package itez.core.wrapper.dbo.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.ArrayUtils;

public class Querys implements Serializable {

	private static final long serialVersionUID = 4343614905990503920L;
	
	public static enum LOGIC {
    	
    	AND(" AND ") , OR(" OR ");
    	
    	private String sign;
    	
    	LOGIC(String sign){
    		this.sign = sign;
    	}
    	
    	public String getSign(){
    		return this.sign;
    	}
    }

	private List<Querys> qsList = new ArrayList<>();
	private List<Query> qList = new ArrayList<>();
	private LOGIC logic = LOGIC.AND;
	
	public static Querys create(Query query){
		Querys qs = new Querys();
		qs.qList.add(query);
		return qs;
	}
	
	public static Querys create(Query query, LOGIC logic){
		Querys qs = new Querys();
		qs.qList.add(query);
		qs.setLogic(logic);
		return qs;
	}
	
	public static Querys create(Querys querys, LOGIC logic){
		Querys qs = new Querys();
		qs.qsList.add(querys);
		qs.setLogic(logic);
		return qs;
	}
	
	public static Querys and(){
		Querys qs = new Querys();
		qs.setLogic(LOGIC.AND);
		return qs;
	}
	
	public static Querys or(){
		Querys qs = new Querys();
		qs.setLogic(LOGIC.OR);
		return qs;
	}
	
	public static Querys and(Query query){
		return create(query, LOGIC.AND);
	}
	
	public static Querys or(Query query){
		return create(query, LOGIC.OR);
	}
	
	public static Querys and(Querys querys){
		return create(querys, LOGIC.AND);
	}
	
	public static Querys or(Querys querys){
		return create(querys, LOGIC.OR);
	}
	
	public Querys add(Query query){
		this.qList.add(query);
		return this;
	}
	
	public Querys add(Querys querys){
		this.qsList.add(querys);
		return this;
	}
	
	public Object[] getArgs(){
		Object[] args = this.qList.stream().filter(q -> q.hasArg()).map(q -> q.getValue()).toArray();
		Object[] args_ = this.qsList.stream().map(qs -> qs.getArgs()).flatMap(Arrays::stream).toArray(Object[]::new);
		return ArrayUtils.addAll(args, args_);
	}
	
	public LOGIC getLogic() {
		return logic;
	}
	public void setLogic(LOGIC logic) {
		this.logic = logic;
	}
	public List<Querys> getQsList() {
		return qsList;
	}
	public List<Query> getQList() {
		return qList;
	}
}
