package itez.core.wrapper.dbo.model;

import java.io.Serializable;

public class Query implements Serializable {
	
	private static final long serialVersionUID = 4393699885873048442L;
    
    public static enum LOGIC {
    	
    	LIKE(" LIKE ")
    	, GT(" > ")				//Greater Than
    	, GE(" >= ")			//Greater than Or Equals
    	, LT(" < ")				//Less Than
    	, LE(" <= ")			//Less than Or Equals
    	, EQ(" = ")				//Equals
    	, NE(" != ")			//Not Equals
    	, NU(" IS ")		//IS NULL
    	, NN(" IS NOT ")	//IS NOT NULL
    	, IN(" IN ");			//IN
    	
    	private String sign;
    	
    	LOGIC(String sign){
    		this.sign = sign;
    	}
    	
    	public String getSign(){
    		return this.sign;
    	}
    }

    private String name;
    private Object value;
    private LOGIC logic = LOGIC.EQ;

    public static Query create(String name, Object value, LOGIC logic) {
        Query Query = new Query();
        Query.setName(name);
        Query.setValue(value);
        Query.setLogic(logic);
        return Query;
    }
    
    public static Query like(String name, Object value){
    	return create(name, value, LOGIC.LIKE);
    }
    
    public static Query gt(String name, Object value){
    	return create(name, value, LOGIC.GT);
    }
    
    public static Query ge(String name, Object value){
    	return create(name, value, LOGIC.GE);
    }
    
    public static Query lt(String name, Object value){
    	return create(name, value, LOGIC.LT);
    }
    
    public static Query le(String name, Object value){
    	return create(name, value, LOGIC.LE);
    }
    
    public static Query eq(String name, Object value){
    	return create(name, value, LOGIC.EQ);
    }
    
    public static Query ne(String name, Object value){
    	return create(name, value, LOGIC.NE);
    }
    
    public static Query nu(String name){
    	return create(name, null, LOGIC.NU);
    }
    
    public static Query nn(String name){
    	return create(name, null, LOGIC.NN);
    }
    
    public static Query in(String name, String value){
    	return create(name, value, LOGIC.IN);
    }

    public Query logic(LOGIC logic) {
        this.setLogic(logic);
        return this;
    }
    
    public boolean hasArg(){
    	if(logic == LOGIC.NU || logic == LOGIC.NN || logic == LOGIC.IN) return false;
    	return true;
    }
    

    
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public LOGIC getLogic() {
        return logic;
    }

    public void setLogic(LOGIC logic) {
        this.logic = logic;
    }
}
