package itez.core.wrapper.dbo.model;

import java.util.HashMap;
import java.util.Map;

import javax.sql.DataSource;

import com.jfinal.config.Plugins;
import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.template.source.ClassPathSourceFactory;

import itez.core.runtime.modules.ModuleBase;
import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect;
import itez.core.wrapper.dbo.plugin.EDruidPlugin;
import itez.kit.EFile;
import itez.kit.ELog;
import itez.kit.EProp;
import itez.kit.EUid;
import itez.kit.El;
import itez.kit.cache.ECacheFactory;

public abstract class EMapping {
	
	private final static Map<String, DataSource> configMap = new HashMap<>();
	
	public void regPlugin(Plugins plugins, ModuleBase module){
		DbProp prop = getDataBaseConfig().getConfig();
		DataSource ds;
		String arpName;
		if(configMap.containsKey(prop.getConnName())){
			ds = configMap.get(prop.getConnName());
			arpName = prop.getReName();
		}else{
			arpName = prop.getConnName();
			if(arpName == null) arpName = EUid.generator();
			EDruidPlugin druid = new EDruidPlugin(prop, true);
			if(plugins != null) plugins.add(druid);
			druid.setName(arpName);
			druid.start();
			ds = druid.getDataSource();
			configMap.put(prop.getConnName(), ds);
		}
		
		String basePath = "META-INF/resources";
		String tempPath = module.getModuleView() + "/sql/" + prop.getType().name() + ".sql";
		
		ActiveRecordPlugin arp = new ActiveRecordPlugin(arpName, ds);
		arp.getEngine().setSourceFactory(new ClassPathSourceFactory());
		arp.getEngine().setBaseTemplatePath(basePath);
		if(EFile.existInRes(tempPath)){
			arp.addSqlTemplate(tempPath);
		}else{
			ELog.info("未找到[{}]模块默认的SQL模板文件：{}", module.getModuleName(), tempPath);
		}
		El.addSharedObject(arp.getEngine());
		arp.setCache(ECacheFactory.me.getCache());
		arp.setDialect(EDialect.parseDialect(prop.getType()));
		arp.setDevMode(EProp.DevMode);
		mapping(arp);
		if(plugins != null) plugins.add(arp);
		arp.start();
	}
	
	public abstract IDataBaseConfig getDataBaseConfig();
	protected abstract void mapping(ActiveRecordPlugin arp);
	
}
