package itez.core.wrapper.dbo.generator;

import java.util.List;

import javax.sql.DataSource;

import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.generator.Generator;
import com.jfinal.plugin.activerecord.generator.TableMeta;

import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect;
import itez.core.wrapper.dbo.plugin.EDruidPlugin;
import itez.kit.EStr;

public abstract class EGenerator {
	
	protected void generator(DbProp prop, String modulePackageName, String...prefixes) {
		
		String modelPackageName = modulePackageName + ".model";
		String servicePackageName = modulePackageName + ".service";
		
		// 连接池
		EDruidPlugin druid = new EDruidPlugin(prop);
		druid.start();
		druid.setUseInformationSchema(true);
		DataSource dataSource = druid.getDataSource();
		
		// BaseModel生成器
		String modelOutputDir = PathKit.getRootClassPath() + "/../../src/main/java/" + modelPackageName.replaceAll("\\.", "/");
		String baseModelPackageName = modelPackageName + ".base";
		String baseModelOutputDir = modelOutputDir + "/base";
		EBaseModelGenerator baseModelGen = new EBaseModelGenerator(baseModelPackageName, baseModelOutputDir);
		
		// Model生成器
		EModelGenerator modelGen = new EModelGenerator(modelPackageName, baseModelPackageName, modelOutputDir);
		
		// 总生成器
		Generator generator = new Generator(dataSource, baseModelGen, modelGen);
		
		// Mapping生成器
		EMappingKitGenerator mapping = new EMappingKitGenerator(modulePackageName, modelPackageName, modelOutputDir);
		generator.setMappingKitGenerator(mapping);
		
		// 添加符合筛选规则的表名前缀，只生成符合该前缀的表格
		EMetaBuilder builder = new EMetaBuilder(dataSource, prefixes);
		builder.setDialect(EDialect.parseDialect(druid.getDbType()));
		generator.setMetaBuilder(builder);
		
		// 添加不需要生成的表名（支持正则表达式模糊匹配）
		generator.addExcludedTable("adv");
		
		// 设置是否在 Model 中生成 dao 对象
		// 默认不自动生成Model的dao静态对象，需要在专属的业务层Service中定义私有dao，避免其他业务层或控制层直接对Model进行操作，引起线程安全问题
		generator.setGenerateDaoInModel(false);
		
		// 设置是否生成字典文件
		generator.setGenerateDataDictionary(true);
		
		// 设置需要被移除的表名前缀用于生成modelName。例如表名 "osc_user"，移除前缀 "osc_"后生成的model名为 "User"而非 OscUser
		generator.setRemovedTableNamePrefixes(prefixes);
		
		// 设置生成的BaseModel中的setter方法支持链式调用
		generator.setGenerateChainSetter(true);
		
		// 生成
		generator.generate();
		
		// Service生成器
		String servicePackage;
		String serviceOutputDir;
		if(EStr.isEmpty(servicePackageName)){
			servicePackageName = modelPackageName;
			servicePackageName = servicePackageName.substring(0, servicePackageName.lastIndexOf("."));
			servicePackage = servicePackageName + ".service";
		}else{
			servicePackage = servicePackageName;
		}
		serviceOutputDir = PathKit.getRootClassPath() + "/../../src/main/java/" + servicePackage.replaceAll("\\.", "/");
		
        List<TableMeta> tableMetas = builder.build();
        new EServiceInterfaceGenerator(servicePackage, serviceOutputDir, modelPackageName).generate(tableMetas);
        new EServiceImplGenerator(servicePackage, serviceOutputDir, modelPackageName).generate(tableMetas);
	}
	
}
