package itez.core.wrapper.dbo.dialect;

import com.jfinal.plugin.activerecord.dialect.SqlServerDialect;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.EStr;
import itez.kit.exception.ErrException;

import java.util.List;
import java.util.stream.Collectors;

public class SqlServerDialectImpl extends SqlServerDialect implements IDialect {

	@Override
	public String genQuery(String table, String loadColumns, Querys qs, String groupBy, String orderBy, Object limit) {
		StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        sqlBuilder.append(loadColumns).append(" FROM ").append(table).append(" ");
        querysFormat(qs, sqlBuilder);
        if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
        if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
        if (limit == null) return sqlBuilder.toString();
        if (limit instanceof Number) {
            StringBuilder ret = new StringBuilder();
            ret.append("SELECT * FROM ( SELECT row_number() over (order by tempcolumn) temprownumber, * FROM ");
            ret.append(" ( SELECT TOP ").append(limit).append(" tempcolumn=0,");
            ret.append(sqlBuilder.toString().replaceFirst("(?i)select", ""));
            ret.append(")vip)mvp ");
            return ret.toString();
        } else if (limit instanceof String && limit.toString().contains(",")) {
            String[] startAndEnd = limit.toString().split(",");
            String start = startAndEnd[0];
            String end = startAndEnd[1];
            StringBuilder ret = new StringBuilder();
            ret.append("SELECT * FROM ( SELECT row_number() over (order by tempcolumn) temprownumber, * FROM ");
            ret.append(" ( SELECT TOP ").append(end).append(" tempcolumn=0,");
            ret.append(sqlBuilder.toString().replaceFirst("(?i)select", ""));
            ret.append(")vip)mvp where temprownumber>").append(start);
            return ret.toString();
        } else {
            throw new ErrException("sql limit is error!,limit must is Number of String like \"0,10\"");
        }
	}

	@Override
	public String genPageSelect(String loadColumns) {
		return "SELECT " + loadColumns;
	}

	@Override
	public String genPageQuery(String table, Querys qs, String groupBy, String orderBy) {
		StringBuilder sqlBuilder = new StringBuilder(" FROM ").append(table);
		querysFormat(qs, sqlBuilder);
        if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
		return sqlBuilder.toString();
	}
    
    private void querysFormat(Querys querys, StringBuilder sqlBuilder) {
    	if(querys == null) return;
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		boolean hasQuery = EArr.isNotEmpty(qList);
		boolean hasQuerys = EArr.isNotEmpty(qsList);
		if(hasQuery || hasQuerys) sqlBuilder.append(" WHERE ");
		if(hasQuery){
            sqlBuilder.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
		if(hasQuery && hasQuerys) sqlBuilder.append(querys.getLogic().getSign());
		if(hasQuerys){
            sqlBuilder.append(qsList.stream().map(qs -> querysTemp(qs)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
    }
    
    private String querysTemp(Querys querys){
    	StringBuilder sql = new StringBuilder("( ");
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		boolean hasQuery = EArr.isNotEmpty(qList);
		boolean hasQuerys = EArr.isNotEmpty(qsList);
		if(hasQuery){
			sql.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
		if(hasQuery && hasQuerys) sql.append(querys.getLogic().getSign());
		if(hasQuerys){
			sql.append(qsList.stream().map(qs -> querysTemp(qs)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
    	sql.append(" )");
    	return sql.toString();
    }
    
    private String queryTemp(Query q){
    	String temp;
    	if(q.getLogic() == Query.LOGIC.NU || q.getLogic() == Query.LOGIC.NN){
    		temp = String.format("%s%snull", q.getName(), q.getLogic().getSign());
    	}else if(q.getLogic() == Query.LOGIC.IN){
    		temp = String.format("%s%s(%s)", q.getName(), q.getLogic().getSign(), q.getValue());
    	}else{
    		temp = String.format("%s%s?", q.getName(), q.getLogic().getSign());
    	}
    	return temp;
    }

}
