package itez.core.wrapper.dbo.dialect;

import com.jfinal.plugin.activerecord.dialect.MysqlDialect;

import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EArr;
import itez.kit.ERegex;
import itez.kit.EStr;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;


public class MysqlDialectImpl extends MysqlDialect implements IDialect {

	@Override
	public String genQuery(String table, String loadColumns, Querys qs, String groupBy, String orderBy, Object limit) {
		loadColumns = genColumns(loadColumns);
		StringBuilder sqlBuilder = new StringBuilder("SELECT ");
		sqlBuilder.append(loadColumns).append(" FROM  `").append(table).append("` ");
		querysFormat(qs, sqlBuilder);
		if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
        if (limit != null) sqlBuilder.append(" LIMIT ").append(limit);
        return sqlBuilder.toString();
	}

	@Override
	public String genPageSelect(String loadColumns) {
		loadColumns = genColumns(loadColumns);
		return "SELECT " + loadColumns;
	}

	@Override
	public String genPageQuery(String table, Querys qs, String groupBy, String orderBy){
        StringBuilder sqlBuilder = new StringBuilder(" FROM `").append(table).append("`");
		querysFormat(qs, sqlBuilder);
		if (EStr.notEmpty(groupBy)) sqlBuilder.append(" GROUP BY ").append(groupBy);
		if (EStr.notEmpty(orderBy)) sqlBuilder.append(" ORDER BY ").append(orderBy);
		return sqlBuilder.toString();
	}
	
	private String genColumns(String columns){
		if(EStr.isEmpty(columns)) return " * ";
		String[] colArr = columns.split(",");
		columns = Arrays.stream(colArr).map(c -> ERegex.checkVar(c) ? "`".concat(c.trim()).concat("`") : c.trim()).collect(Collectors.joining(","));
		return columns;
	}
    
    private void querysFormat(Querys querys, StringBuilder sqlBuilder) {
    	if(querys == null) return;
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		boolean hasQuery = EArr.isNotEmpty(qList);
		boolean hasQuerys = EArr.isNotEmpty(qsList);
		if(hasQuery || hasQuerys) sqlBuilder.append(" WHERE ");
		if(hasQuery){
            sqlBuilder.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
		if(hasQuery && hasQuerys) sqlBuilder.append(querys.getLogic().getSign());
		if(hasQuerys){
            sqlBuilder.append(qsList.stream().map(qs -> querysTemp(qs)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
    }
    
    private String querysTemp(Querys querys){
    	StringBuilder sql = new StringBuilder("( ");
		List<Query> qList = querys.getQList();
		List<Querys> qsList = querys.getQsList();
		boolean hasQuery = EArr.isNotEmpty(qList);
		boolean hasQuerys = EArr.isNotEmpty(qsList);
		if(hasQuery){
			sql.append(qList.stream().map(q -> queryTemp(q)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
		if(hasQuery && hasQuerys) sql.append(querys.getLogic().getSign());
		if(hasQuerys){
			sql.append(qsList.stream().map(qs -> querysTemp(qs)).collect(Collectors.joining(querys.getLogic().getSign())));
		}
    	sql.append(" )");
    	return sql.toString();
    }
    
    private String queryTemp(Query q){
    	String temp;
    	if(q.getLogic() == Query.LOGIC.NU || q.getLogic() == Query.LOGIC.NN){
    		temp = String.format("`%s`%snull", q.getName(), q.getLogic().getSign());
    	}else if(q.getLogic() == Query.LOGIC.IN){
    		temp = String.format("`%s`%s(%s)", q.getName(), q.getLogic().getSign(), q.getValue());
    	}else{
    		temp = String.format("`%s`%s?", q.getName(), q.getLogic().getSign());
    	}
    	return temp;
    }

    /*
    public static void main(String[] args) {
		
		Querys qs1 = Querys.or(Query.eq("domain", "domain")).add(Query.eq("level", 2));
		Querys qs2 = Querys.and(qs1).add(Query.eq("loginName", "loginName"));
		
		Object[] arg = qs2.getArgs();
		System.out.println(Arrays.toString(arg));
		System.out.println("===============================");
		
		EMysqlDialect dialect = new EMysqlDialect();
		String sql = dialect.genQuery("table", "*", qs2, "sort desc", 1);
		System.out.println(sql);
	}
	*/

}
