package itez.core.wrapper.dbo.dialect;

import com.jfinal.plugin.activerecord.dialect.Dialect;

import itez.kit.EStr;

public class EDialect {
	
	public enum DbType {
		mysql, postgresql, oracle, sqlserver;
		public static DbType fromString(String str){
			if(EStr.notEmpty(str)){
				try {
					return Enum.valueOf(DbType.class, str.trim());
				} catch (Exception e) {
					return null;
				}
			}else{
				return null;
			}
		}
	}

	public static Dialect parseDialect(DbType dbType){
		Dialect dialect = null;
		if(dbType.equals(DbType.mysql)){
			dialect = new MysqlDialectImpl();
		}else if(dbType.equals(DbType.postgresql)){
			dialect = new PostgreSqlDialectImpl();
		}else if(dbType.equals(DbType.oracle)){
			dialect = new OracleDialectImpl();
		}else if(dbType.equals(DbType.sqlserver)){
			dialect = new SqlServerDialectImpl();
		}
		return dialect;
	}
	
}
