package itez.core.wrapper.dbo;

import java.util.HashSet;
import java.util.Set;

import com.jfinal.config.Plugins;

import itez.core.launch.JW;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.wrapper.dbo.model.EMapping;
import itez.kit.EClass;
import itez.kit.EClassSearch;
import itez.kit.ELog;
import itez.kit.log.ELogBase;

public class DbManager {

	private static final ELogBase log = ELog.log(DbManager.class);
	public static final DbManager me = new DbManager();
	private DbManager(){}
	private final static String MAIN_DATABASE_NAME = "main";

	public void initDBPlugins(Plugins plugins){
		if(!JW.getLicenseVali()) {
			log.error("当前JWinner版本未通过授权！");
			return;
		}
		Set<Class<?>> mappingList = EClassSearch.getClassList(JW.DataModelPackage, true, EMapping.class, null);
		Set<Class<?>> mappingLoading = new HashSet<>();
		mappingList.forEach(clazz -> {
			EMapping mapping = (EMapping) EClass.newInstance(clazz);
			DbProp prop = mapping.getDataBaseConfig().getConfig();
			if(prop.getConnName().equals(MAIN_DATABASE_NAME) && prop.getReName() == null){
				mapping.regPlugin(plugins, findModule(clazz));
			}else{
				mappingLoading.add(clazz);
			}
		});
		mappingLoading.forEach(clazz -> {
			EMapping mapping = (EMapping) EClass.newInstance(clazz);
			mapping.regPlugin(plugins, findModule(clazz));
		});
		log.info("数据库模型映射完成");
	}
	
	private ModuleBase findModule(Class<?> clazz){
		String pkg = clazz.getPackage().getName();
		ModuleBase module = ModuleManager.me.findModuleConfig(pkg);
		if(module == null) throw new RuntimeException("未找到对应的模块配置文件：" + pkg);
		return module;
	}
	
}
