package itez.core.wrapper.controller;

import com.jfinal.aop.Clear;
import com.jfinal.core.NotAction;
import com.jfinal.kit.PathKit;
import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;

import itez.core.wrapper.render.ERender;
import itez.kit.EProp;
import itez.kit.EStr;
import itez.kit.El;

@Clear
public class EControllerSite extends EController {

	private final static String ENGINE_NAME = "site";
	private static Engine engine = null;
	
	private void initEngine(){
		String siteTempRoot = EStr.ifEmpty(EProp.getProp().get("SiteTempRoot"), PathKit.getWebRootPath() + "/siteTemp");
		if(engine != null) return;
		engine = Engine.create(ENGINE_NAME);
		engine.setDevMode(EProp.DevMode);
		engine.setSourceFactory(new FileSourceFactory());
		engine.setBaseTemplatePath(siteTempRoot);
		engine.addSharedFunction("/common/layout_base.html");
		El.addSharedObject(engine);
	}
	
	@Override
	@NotAction
	public void render(String view) {
		initEngine();
		try {
			super.render(new ERender(engine, attr().getDomain().concat("/").concat(view)));
		} catch (Exception e) {
			super.renderText("页面渲染出现异常，请稍后再试！");
		}
	}

	@NotAction
	public void render(String subDomain, String view) {
		initEngine();
		try {
			super.render(new ERender(engine, attr().getDomain().concat("/").concat(subDomain).concat("/").concat(view)));
		} catch (Exception e) {
			super.renderText("页面渲染出现异常，请稍后再试！");
		}
	}
	
	@NotAction
	public static Engine getEngine(){
		return engine;
	}
	
}
