package itez.core.util.grouping;

import com.jfinal.plugin.activerecord.Record;

public class GroupingPlanByGroupSize extends GroupingPlanBase {

	private Integer groupSize; //分组内数据量限额

	public GroupingPlanByGroupSize(Integer groupSize) {
		this.groupSize = groupSize;
	}
	
	@Override
	public GroupingPlanBase groupingDo() {
		sortData();
		Integer groupCount = totalCount / groupSize + (totalCount % groupSize == 0 ? 0 : 1);
		for(int i = 0; i < groupCount; i++) createGroup();
		Integer groupIndex = 0;
		for(Record rec : data){
			getGroups().get(groupIndex++).putData(rec);
			if(groupIndex == groupCount) groupIndex = 0;
		}
		return this;
	}
	
	public Integer getGroupSize() {
		return groupSize;
	}

}
