package itez.core.util.grouping;

import com.jfinal.plugin.activerecord.Record;

public class GroupingPlanByGroupCount extends GroupingPlanBase {

	private Integer groupCount; //分组个数

	public GroupingPlanByGroupCount(Integer groupCount) {
		this.groupCount = groupCount;
	}
	
	@Override
	public GroupingPlanBase groupingDo() {
		sortData();
		for(int i = 0; i < groupCount; i++) createGroup();
		Integer groupIndex = 0;
		for(Record rec : data){
			getGroups().get(groupIndex++).putData(rec);
			if(groupIndex == groupCount) groupIndex = 0;
		}
		return this;
	}
	
	public Integer getGroupCount() {
		return groupCount;
	}

}
