package itez.core.util.drawing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.List;

import com.beust.jcommander.internal.Lists;
import com.jfinal.kit.ElKit;
import com.jfinal.kit.Kv;

import itez.kit.EStr;

public class TextElement extends BoardElement {
	
	private String text;
	private String sx;
	private String sy;
	private String swidth;
	private String sheight;
	
	private Color color = new Color(0, 0, 0, 255);
	private String fontName = "Microsoft YaHei";
	private Integer fontStyle = 0;
	private Integer fontSize = 20;
	
	public TextElement(String text, Integer x, Integer y) {
		init(text, x, y, null, null, null, null, null, null);
	}
	
	public TextElement(String text, Integer x, Integer y, Integer width, Integer height) {
		init(text, x, y, width, height, null, null, null, null);
	}
	
	public TextElement(String text, Integer x, Integer y, String swidth, String sheight) {
		init(text, x, y, null, null, null, null, swidth, sheight);
	}
	
	public TextElement(String text, String sx, String sy) {
		init(text, null, null, null, null, sx, sy, null, null);
	}
	
	public TextElement(String text, String sx, String sy, Integer width, Integer height) {
		init(text, null, null, width, height, sx, sy, null, null);
	}
	
	public TextElement(String text, String sx, String sy, String swidth, String sheight) {
		init(text, null, null, null, null, sx, sy, swidth, sheight);
	}
	
	protected void init(String text, Integer x, Integer y, Integer width, Integer height, String sx, String sy, String swidth, String sheight){
		type = Type.TEXT;
		this.text = text;
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.sx = sx;
		this.sy = sy;
		this.swidth = swidth;
		this.sheight = sheight;
	}
	
	public TextElement setFont(String fontName, Integer fontStyle, Integer fontSize){
		this.fontName = fontName;
		this.fontStyle = fontStyle;
		this.fontSize = fontSize;
		return this;
	}

	@Override
	public void drawing(Board board, Graphics outG) {
		Font font = new Font(fontName, fontStyle, fontSize);
		FontMetrics metrics = outG.getFontMetrics(font);
		outG.setFont(font);
		outG.setColor(color);
		int lineHeight = metrics.getHeight(), sumHeight = 0;
		List<String> lines = Lists.newArrayList();
		if(EStr.notEmpty(swidth) && swidth.endsWith("%")) width = (int)(board.getWidth() * parsePercent(swidth));
		if(EStr.notEmpty(sheight) && sheight.endsWith("%")) height = (int)(board.getHeight() * parsePercent(sheight));
		if(width != null){
			int lineWidth = 0, len = text.length(), ind = 0;
			StringBuilder lineText = new StringBuilder();
			while(ind < len){
				char chr = text.charAt(ind);
				int chrWid = metrics.charWidth(chr);
				if(lineWidth + chrWid > width){
					lines.add(lineText.toString());
					sumHeight += lineHeight;
					lineText.delete(0, lineText.length());
					if(height != null && sumHeight > height) break;
					if(sumHeight > board.getHeight()) break;
					lineText.append(chr);
					lineWidth = chrWid;
				}else{
					lineText.append(chr);
					lineWidth += chrWid;
				}
				ind++;
			}
			if(lineText.length() > 0){
				lines.add(lineText.toString());
				sumHeight += lineHeight;
			}
			if(height == null) height = sumHeight;
		}else{
			width = metrics.stringWidth(text);
			height = lineHeight;
			lines.add(text);
		}
        Kv data = Kv.by("text", text).set("centerX", board.getCenterX() - width / 2).set("centerY", board.getCenterY() - height / 2);
		if(EStr.notEmpty(sx)) x = ElKit.eval(sx, data);
		if(EStr.notEmpty(sy)) y = ElKit.eval(sy, data);
		for(int i=0, size=lines.size(); i<size; i++){
			outG.drawString(lines.get(i), x, y + i * lineHeight);
		}
	}

	public String getText() {
		return text;
	}

	public TextElement setText(String text) {
		this.text = text;
		return this;
	}

	public Color getColor() {
		return color;
	}

	public TextElement setColor(Color color) {
		this.color = color;
		return this;
	}

	public String getFontName() {
		return fontName;
	}

	public TextElement setFontName(String fontName) {
		this.fontName = fontName;
		return this;
	}

	public Integer getFontStyle() {
		return fontStyle;
	}

	public TextElement setFontStyle(Integer fontStyle) {
		this.fontStyle = fontStyle;
		return this;
	}

	public Integer getFontSize() {
		return fontSize;
	}

	public TextElement setFontSize(Integer fontSize) {
		this.fontSize = fontSize;
		return this;
	}

}
