package itez.core.util.drawing;

import java.awt.Graphics;
import java.awt.image.BufferedImage;

import com.jfinal.kit.ElKit;
import com.jfinal.kit.Kv;

import itez.kit.EStr;

public class ImageElement extends BoardElement {

	private BufferedImage img = null;
	private String sx;
	private String sy;
	private String swidth;
	private String sheight;
	
	public ImageElement(String path, Integer x, Integer y) {
		init(path, x, y, null, null, null, null, null, null);
	}
	
	public ImageElement(String path, Integer x, Integer y, Integer width, Integer height) {
		init(path, x, y, width, height, null, null, null, null);
	}
	
	public ImageElement(String path, Integer x, Integer y, String swidth, String sheight) {
		init(path, x, y, null, null, null, null, swidth, sheight);
	}
	
	public ImageElement(String path, String sx, String sy) {
		init(path, null, null, null, null, sx, sy, null, null);
	}
	
	public ImageElement(String path, String sx, String sy, Integer width, Integer height) {
		init(path, null, null, width, height, sx, sy, null, null);
	}

	public ImageElement(String path, String sx, String sy, String swidth, String sheight) {
		init(path, null, null, null, null, sx, sy, swidth, sheight);
	}
	
	protected void init(String path, Integer x, Integer y, Integer width, Integer height, String sx, String sy, String swidth, String sheight){
		type = Type.IMAGE;
		if(EStr.isEmpty(path)) error("图片地址无效");
		img = getImage(path);
		if(img == null) error("图片加载失败：" + path);
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.sx = sx;
		this.sy = sy;
		this.swidth = swidth;
		this.sheight = sheight;
	}
	
	@Override
	public void drawing(Board board, Graphics outG) {
		if(EStr.notEmpty(swidth) && swidth.endsWith("%")) width = (int)(board.getWidth() * parsePercent(swidth));
		if(EStr.notEmpty(sheight) && sheight.endsWith("%")) height = (int)(board.getHeight() * parsePercent(sheight));
		if(width == null) width = img.getWidth();
		if(height == null) height = img.getHeight();
        Kv data = Kv.by("img", img).set("centerX", board.getCenterX() - width / 2).set("centerY", board.getCenterY() - height / 2);
		if(EStr.notEmpty(sx)) x = ElKit.eval(sx, data);
		if(EStr.notEmpty(sy)) y = ElKit.eval(sy, data);
        outG.drawImage(img, x, y, width, height, imageobserver);
	}

}
