package itez.core.runtime.task;

import java.util.Date;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.Scheduler;
import itez.kit.EClass;
import itez.plat.main.model.Task;

public class TaskKit {

	private Scheduler scheduler;

	private String id;
	private String dbid;
	private String cron;
	private String clazz;
	private ETask task;
	private boolean daemon;
	
	public TaskKit(Task model){
		dbid = model.getId();
		cron = model.getCron();
		clazz = model.getTaskClass();
		daemon = model.getDaemon() == 1;
	}
	
	public void schedule() {
		scheduler = new Scheduler();
		Object t = EClass.newInstance(clazz);
		if (t instanceof ETask) {
			task = (ETask) t;
			id = scheduler.schedule(cron, task);
			ESchedulerListener listener = new ESchedulerListener(id, dbid);
			scheduler.addSchedulerListener(listener);
		} else {
			scheduler = null;
			throw new IllegalStateException("Task 必须是ETask 类型：" + clazz);
		}
		scheduler.setDaemon(daemon);
	}

	public void start() {
		scheduler.start();
	}

	public void stop() {
		task.stop();
		scheduler.stop();
	}
	
	public void reset(String pattern){
		scheduler.reschedule(dbid, pattern);
	}
	
	public String getId() {
		return id;
	}

	public String getDbid() {
		return dbid;
	}
	
	public static Date getNextDate(String pattern){
		Predictor pre = new Predictor(pattern);
		return pre.nextMatchingDate();
	}
	
}
