package itez.core.runtime.task;

import it.sauronsoftware.cron4j.Predictor;
import it.sauronsoftware.cron4j.SchedulerListener;
import it.sauronsoftware.cron4j.TaskExecutor;
import itez.core.runtime.service.Ioc;
import itez.plat.main.service.TaskService;

public class ESchedulerListener implements SchedulerListener {

	private String id;
	private String dbid;
	private static TaskService taskSer = Ioc.get(TaskService.class);
	
	public ESchedulerListener(String id, String dbid){
		this.id = id;
		this.dbid = dbid;
	}
	
	@Override
	public void taskLaunching(TaskExecutor executor) {
		//System.out.println("launch: ---> id: " + id + ", dbid: " + dbid);
		Predictor pre = new Predictor(executor.getScheduler().getSchedulingPattern(id));
		taskSer.runBefore(dbid, pre.nextMatchingDate());
	}

	@Override
	public void taskSucceeded(TaskExecutor executor) {
		//System.out.println("Succeed: ---> id: " + id + ", dbid: " + dbid);
		taskSer.runAfter(dbid, true, "");
	}

	@Override
	public void taskFailed(TaskExecutor executor, Throwable exception) {
		//System.out.println("Failed: ---> id: " + id + ", dbid: " + dbid + ", error: " + exception.getMessage());
		taskSer.runAfter(dbid, false, exception.getMessage());
	}

}
