package itez.core.runtime.session;

import javax.servlet.http.HttpServletRequest;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import itez.core.launch.JW;
import itez.core.runtime.EContext;
import itez.kit.ECookie;
import itez.kit.EProp;
import itez.kit.EStr;

public class TokenManager {

	public final static TokenManager me = new TokenManager();
	private TokenManager(){}

	public final static Integer SessionTimeOutMinutes = EProp.SessionTimeOutMinutes; // Session保持时间，默认30分钟
	public final static String SessionHeaderName = "X-Auth-Token"; // Token在Request.Header中的键名
	public final static String SessionAttrName = "JWSID"; // Token在Request.Attr及Params中的键名
	public final static String SessionCacheName = "JWSESSION"; // Token在Cache中的存储器名称
	public final static String TokenUuid = "uuid"; // Token中的UUID键名
	
	/**
	 * 从请求中获得Token
	 * @return
	 */
	public String getToken(){
		HttpServletRequest request = EContext.getRequest();
		if(request == null) return null;
		String id4Cookie = ECookie.getCookie(request, getCookieKey());
		String id4Attribute = EContext.getRequestAttr(SessionAttrName);
		String id4Params = request.getParameter(SessionAttrName);
		String id4Header = request.getHeader(SessionHeaderName);
		return EStr.findUseful(id4Cookie, id4Attribute, id4Params, id4Header);
	}
	
	/**
	 * 解析Token，返回uuid
	 * @return
	 */
	public String parseToken() {
		return parseToken(getToken());
	}
	
	/**
	 * 解析Token，返回uuid
	 * @param token
	 * @return
	 */
	public String parseToken(String token) {
		if(EStr.isEmpty(token)) return null;
		String uuid = null;
		try {
			Jws<Claims> jws = Jwts.parser().setSigningKey(JW.TokenSecret).parseClaimsJws(token);
			Claims claims = jws.getBody();
			uuid = claims.getId();
		} catch (Exception e) {
		}
		return uuid;
	}
	
	/**
	 * 生成Token
	 * @param uuid
	 * @return
	 */
	public String createToken(String uuid){
		Claims claims = Jwts.claims();
		claims.setId(uuid);
		return Jwts.builder().setClaims(claims).signWith(SignatureAlgorithm.HS512, JW.TokenSecret).compact();
	}

	public String getCookieKey(){
		return String.format("_%s_%s_", SessionAttrName, EContext.getAttr().getDomain());
	}
	
	public String getCookieKey(String name){
		return String.format("_%s_%s_%s_", SessionAttrName, EContext.getAttr().getDomain(), name);
	}
	
}
