package itez.core.runtime.session;

import java.util.HashMap;
import java.util.Map;

import itez.core.wrapper.controller.EController;

/**
 * 实现FlashMessage功能
 * 便于重定向之后，仍然能将服务器端消息发送到前台
 * 
 * @author netwild
 *
 */
public class FlashMessage {
    
    public final static FlashMessage me = new FlashMessage();
    private FlashMessage(){}

    private final static String FLASH_SESSION_CODE = "_JW_FM_";
    
    /**
     * 将Controller中的FlashMessage保存到Session
     */
    public void store(EController controller){
        HashMap<String, Object> flash = controller.getFlashMap();
        if (flash != null) {
        	controller.setSessionAttr(FLASH_SESSION_CODE, flash);
        }
    }
    
    /**
     * 将Session中保存的FlashMessage添加到Controller中
     */
    public void render(EController controller){
        HashMap<String, Object> flash = controller.getSessionAttr(FLASH_SESSION_CODE);
        if (flash != null) {
            for (Map.Entry<String, Object> entry : flash.entrySet()) {
                controller.setAttr(entry.getKey(), entry.getValue());
            }
            controller.removeSessionAttr(FLASH_SESSION_CODE);
        }
    }
    
}
