package itez.core.runtime.session;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;

import itez.kit.EProp;
import itez.kit.exception.ErrException;

public class EServletRequestWrapper extends HttpServletRequestWrapper {
	
    private ESessionBase httpSession;

	public EServletRequestWrapper(HttpServletRequest request) {
		super(request);
	}
	
	@Override
	public HttpSession getSession() {
		return getSession(true);
	}
	
	@Override
	public HttpSession getSession(boolean create) {
		return session(create);
	}
	
	public ESessionBase session(boolean create){
		if(httpSession != null){
			return httpSession;
		}else if (create) {
			String sessionPlan = EProp.SessionPlan.toLowerCase();
			if(sessionPlan.equals("db")){
				httpSession = new ESessionDb(getServletContext());
			}else if(sessionPlan.equals("cache")){
				httpSession = new ESessionCache(getServletContext());
			}else if(sessionPlan.equals("cookie")){
				httpSession = new ESessionCookie(getServletContext());
			}else{
				throw new ErrException("未设置有效的Session共享方案名称：" + sessionPlan);
			}
        }
		return httpSession;
	}
	
	/**
	 * 返回Request的包装对象，主要用于并发队列操作
	 * @return
	 */
	public ERequestBean wrapper(Class<?> handleService){
		return new ERequestBean((HttpServletRequest) super.getRequest(), handleService);
	}
	
	/**
	 * 返回Request的包装对象，主要用于并发队列操作
	 * @return
	 */
	public ERequestBean wrapper(String handleServiceName){
		return new ERequestBean((HttpServletRequest) super.getRequest(), handleServiceName);
	}

}
