package itez.core.runtime.session;

import java.util.concurrent.TimeUnit;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;

import itez.kit.EDate;

public class CaffeineTest {
	
	private static LoadingCache<String, String> cache = Caffeine.newBuilder()
			.maximumSize(3)
			//.expireAfterAccess(3, TimeUnit.SECONDS)
			.expireAfterWrite(3, TimeUnit.SECONDS)
			.removalListener((String key, String val, RemovalCause cause) -> {
				System.out.println("   > 触发移除监听器：");
				System.out.println("     > 原因：" + cause);
				System.out.println("     > 被动：" + cause.wasEvicted());
				System.out.println("     > Key：" + key);
				System.out.println("     > Val：" + val);
			})
			.build(key -> key + "_" + EDate.getTime());

	public static void main(String[] args) throws InterruptedException {

//		System.out.println("get");
//		System.out.println(cache.getIfPresent("k1"));
//		System.out.println("-------------------------------------");

//		Thread.sleep(2000L);
		
		System.out.println("put");
		cache.put("k1", "k1 ok");
		cache.put("k2", "k2 ok");
		System.out.println("-------------------------------------");

		Thread.sleep(2000L);
		
		System.out.println("refresh");
		cache.refresh("k1");
		System.out.println("-------------------------------------");

		//Thread.sleep(2000L);
		
		//System.out.println("refresh");
		//cache.refresh("k1");
		//System.out.println("-------------------------------------");
		
		Thread.sleep(2000L);
		
		System.out.println("get");
		System.out.println("K1：" + cache.getIfPresent("k1"));
		System.out.println("K2：" + cache.getIfPresent("k2"));
		System.out.println("-------------------------------------");


		/**
		 * 
		Thread.sleep(2000L);
		
		System.out.println("get");
		System.out.println(cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");

		Thread.sleep(1000L);
		
		System.out.println("invalidate");
		cache.invalidate("k1");
		System.out.println("-------------------------------------");

		Thread.sleep(2000L);
		
		System.out.println("get");
		System.out.println(cache.getIfPresent("k2"));
		System.out.println("-------------------------------------");
		
		//cache.get("k1");
		System.out.println("ref之前：value:" + cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");
		cache.refresh("k1");
		System.out.println("-------------------------------------");
		System.out.println("ref之后：value:" + cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");
		
		Thread.sleep(2000L);

		//cache.get("k2");
		System.out.println("ref之前：value:" + cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");
		cache.refresh("k1");
		System.out.println("-------------------------------------");
		System.out.println("ref之后：value:" + cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");
		
		Thread.sleep(4000L);

		//cache.get("k1");
		System.out.println("ref之前：value:" + cache.getIfPresent("k1"));
		System.out.println("-------------------------------------");
		cache.refresh("k1");
		System.out.println("-------------------------------------");
		System.out.println("ref之后：value:" + cache.getIfPresent("k1"));
		 */
	}
}
