package itez.core.runtime.service.common;

public interface IUserService {

	public IUser getEmptyUser();
	
	public IUser findById(String userId);
	public IUser findByEmail(String email);
	public IUser findByEmail(String domain, String email);
	public IUser findByPhone(String phone);
	public IUser findByPhone(String domain, String phone);
	public IUser findByIdNum(String idNum);
	public IUser findByIdNum(String domain, String idNum);
	public IUser findByLogin(String loginName);
	public IUser findByLogin(String domain, String loginName);
	public IUser findByLogin(String domain, String loginName, String passWord);

	public boolean checkRole(IUser user, String roleCode);
	public boolean checkRoles(IUser user, String... roleCodeArr);
	public boolean checkRolesAny(IUser user, String... roleCodeArr);
	public boolean checkPerm(IUser user, String permCode);
	public boolean checkPerms(IUser user, String... permCodeArr);
	public boolean checkPermsAny(IUser user, String... permCodeArr);
	
}
