package itez.core.runtime.service;

import itez.core.runtime.service.common.ICompService;
import itez.core.runtime.service.common.IUserService;

/**
 * 依赖注入工具类
 * @author netwild
 *
 */
public class Ioc {

	public static <T> T get(Class<?> interfaceClazz){
		return ServiceManager.me.getService(interfaceClazz);
	}
	
	public static void inject(Object object){
		ServiceManager.me.injectMembers(object);
	}
	
	public static ICompService getComp(){
		return ServiceManager.me.getCompService();
	}
	
	public static IUserService getUser(){
		return ServiceManager.me.getUserService();
	}
	
}
