package itez.core.runtime.service;

import java.util.List;

import itez.core.wrapper.dbo.model.EModel;

public interface IService {

	/**
	 * 合并主细表（1 vs n）
	 * @category 合并主细表
	 * 
	 * 例如：
	 * 		主表（mainList）	：[{id: 'P1', name: '主1'} ..]
	 * 		细表（subList）	：[{id: 'S1', name: '细1', pId: 'P1'} ..]
	 * 合并：
	 * 		append(mainList, "id", subList, "pId", "sub")
	 * 结果：
	 * 		[{id: 'P1', name: '主1', sub: [{id: 'S1', name: '细1', pId: 'P1'} ..]} ..]
	 * 
	 * @param parentList 主表集合
	 * @param subList 子表集合
	 * @param foreignKey 子表外键
	 * @param joinName 链接别名
	 * @return
	 */
	public <T extends EModel<T>, V extends EModel<V>> List<T> append(List<T> parentList, List<V> subList, String foreignKey, String joinName);

	/**
	 * 合并主细表（1 vs n）
	 * @category 合并主细表
	 * 
	 * 例如：
	 * 		主表（mainList）	：[{id: 'P1', name: '主1'} ..]
	 * 		细表（subList）	：[{id: 'S1', name: '细1', pId: 'P1'} ..]
	 * 合并：
	 * 		append(mainList, "id", subList, "pId", "sub")
	 * 结果：
	 * 		[{id: 'P1', name: '主1', sub: [{id: 'S1', name: '细1', pId: 'P1'} ..]} ..]
	 * 
	 * @param parentList 主表集合
	 * @param primaryKey 主表主键
	 * @param subList 子表集合
	 * @param foreignKey 子表外键
	 * @param joinName 链接别名
	 * @return
	 */
	public <T extends EModel<T>, V extends EModel<V>> List<T> append(List<T> parentList, String primaryKey, List<V> subList, String foreignKey, String joinName);
	
	/**
	 * 表连接（left join right）
	 * @category 表连接（left join right）
	 * 
	 * @param leftList 左侧主表集合
	 * @param leftKey 左侧主表连接字段名称
	 * @param rightList 右侧表集合
	 * @param rightKey 右侧表连接字段名称
	 * @param rightFields 右侧表字段重命名（格式：field 或 field > fieldNew）
	 */
	public <T extends EModel<T>, V extends EModel<V>> List<T> join(List<T> leftList, String leftKey, List<V> rightList, String rightKey, String...rightAs);
	
}
