package itez.core.runtime.modules;

/**
 * 模块配置抽象类
 * 
 * 使用说明： 在模块所在的包内，创建模块配置类，实现本抽象类的相关方法。
 * 注意事项： 模块配置类就是标准的POJO对象，只是需要对ModuleCode等属性设置初始值。
 * 模块划分： JWinner遵循最灵活的模块架构，在系统启动时，会扫描所有存在的控制器。
 *         在对这些控制器进行遍历并设置路由时，会根据控制器所在包，逐层向上搜索，找到最近的模块配置文件。
 *         则将其划分到该模块中。在对该模块中的控制器访问时，则需要在URL中添加模块Path，否则无法访问。
 *         
 *         推荐在Maven中创建独立的Module项目，作为JWinner的独立模块，可单独打成Jar包，按需部署。
 *         在Module项目中：
 *         
 *         1) 模块源码位置：src/main/java -> itez.plat.[moduleView].mvc
 *         2) 视图文件位置：src/main/resources -> META-INF/resources/[moduleView]/temp
 *         3) 静态文件位置：src/main/resources -> META-INF/resources/[moduleView]/asset
 * 
 * @author netwild
 *
 */
public abstract class ModuleBase {
	
	/**
	 * 模块别名
	 * 模块的唯一标识符
	 * @return
	 */
	public abstract String getModuleCode();
	
	/**
	 * 模块名称描述
	 * @return
	 */
	public abstract String getModuleName();
	
	/**
	 * 模块Path
	 * 访问该模块内的所有控制器时都需要以该模块Path为前缀
	 * 例如：服务器域名（xxx.com），应用名（/），模块Path（sso），该模块下某控制器Path（/login）
	 * 那么该控制器的完整访问路径为：http://xxx.com/sso/login
	 * 当模块Path为空时，表示默认模块
	 * @return
	 */
	public abstract String getModulePath();
	public abstract void setModulePath(String modulePath);
	
	/**
	 * 模块视图文件夹名称
	 * 该模块的视图（模板）都存放在该文件夹下
	 * 例如：模块View（sso）
	 * 那么该模块所有的视图文件夹位置为：src/main/resources/META-INF/resources/sso/temp
	 * 请在视图文件夹下创建两个子目录：asset（存放该模块的静态资源）、temp（存放该模块的视图文件）
	 * @return
	 */
	public abstract String getModuleView();
	public abstract void setModuleView(String moduleView);

}
