package itez.core.runtime.injector;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.google.common.collect.Lists;

import itez.core.runtime.EContext;
import itez.kit.EClass;
import itez.kit.EProp;
import itez.kit.EStr;

public class EInjector {

	@SuppressWarnings("unchecked")
	public static final <T> T injectBean(Class<T> beanClass) {
		Object bean = EClass.newInstance(beanClass);
		HttpServletRequest request = EContext.getRequest();
		Map<String, String[]> parasMap = request.getParameterMap();
		injectBean(bean, parasMap, "");
		return (T) bean;
	}
	
	private static boolean injectBean(Object bean, Map<String, String[]> parasMap, String beanName) {
		Class<?> beanClass = bean.getClass();
		String prefix = EStr.notEmpty(beanName) ? beanName + "[%s]" : null;
		ETypeConverter converter = ETypeConverter.me;
		Method[] methods = beanClass.getMethods();
		boolean isEmpty = true;//true表示这个bean里面没有内容，false表示有内容
		for (Method method : methods) {
			String methodName = method.getName();
			if (methodName.startsWith("set") == false || methodName.length() <= 3) continue;
			Class<?>[] methodClasses = method.getParameterTypes();// 获取方法参数类型
			if (methodClasses.length != 1) continue;

			methodName = EStr.toLowerCaseFirst(methodName.substring(3));
			String paraName = prefix != null ? String.format(prefix, methodName) : methodName;

			Class<?> methodClazz = methodClasses[0];

			if (converter.isExistence(methodClazz) || methodClazz == String.class) {
				try {
					String[] values = parasMap.get(paraName);
					if (EStr.isNull(values)) continue;
					String value = values[0];
					if (EStr.isNull(value)) continue;
					Object val = converter.convert(methodClazz, value);
					method.invoke(bean, val);
					isEmpty = false;
				} catch (Exception e) {
					if(EProp.DevMode) e.printStackTrace();
				}
			}else{
				
				Object methodBean = null;

				if (methodClazz == List.class) {
					Type methodType = method.getGenericParameterTypes()[0];
					Class<?> genericClazz = (Class<?>)((ParameterizedType) methodType).getActualTypeArguments()[0];
					methodBean = injectListBean(genericClazz, parasMap, paraName);
				} else {
					methodBean = EClass.newInstance(methodClazz);
					injectBean(methodBean, parasMap, paraName);
				}

				if(methodBean == null) continue;
				
				try {
					method.invoke(bean, methodBean);
				} catch (Exception e) {
					if(EProp.DevMode) e.printStackTrace();
				}
			}
		}
		return isEmpty;
	}

	private static List<Object> injectListBean(Class<?> genericClazz, Map<String, String[]> parasMap, String paraName) {
		List<Object> list = Lists.newArrayList();
		ETypeConverter converter = ETypeConverter.me;
		if (converter.isExistence(genericClazz) || genericClazz == String.class) {
			paraName += "[]";
			String[] vals = parasMap.get(paraName);
			if (vals != null) {
				for (String item : vals) {
					Object val = null;
					try {
						val = item != null ? converter.convert(genericClazz, item) : null;
					} catch (ParseException e) {
						if(EProp.DevMode) e.printStackTrace();
					}
					list.add(val);
				}
			}
		}else{
			boolean isEmpty = false;
			int i = 0;
			while (!isEmpty) {
				Object listBean = EClass.newInstance(genericClazz);
				isEmpty = injectBean(listBean, parasMap, paraName + "[" + i + "]");
				if (isEmpty) break;
				list.add(listBean);
				i++;
			}
		}
		return list;
	}

}
