package itez.core.runtime.auth;

import itez.core.runtime.EContext;
import itez.core.runtime.service.EService;
import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.runtime.session.ESessionBase;
import itez.kit.ERet;
import itez.kit.EStr;

public class AuthService extends EService {
	
	public static ERet authValidator(AuthMode mode){
		
		ESessionBase session = EContext.getSession();
		IUserService userService = Ioc.getUser();
		Boolean logined = session.getLogined();
		IUser user = session.getUser();

		boolean authAccept = false; //鉴权结果，默认为失败
		String authMsg = ""; //错误提示
		
		switch(mode.getAuthCode()){
		case REQ_ROLE: //根据单个角色进行鉴权
			if(userService.checkRole(user, mode.getAuthId())) authAccept = true;
			authMsg = mode.getAuthId();
			break;
		case REQ_ROLES: //根据多个角色进行鉴权（全部满足）
			if(userService.checkRoles(user, mode.getAuthIds())) authAccept = true;
			authMsg = EStr.parseArray(mode.getAuthIds());
			break;
		case REQ_ROLES_ANY: //根据多个角色进行鉴权（满足任意）
			if(userService.checkRolesAny(user, mode.getAuthIds())) authAccept = true;
			authMsg = EStr.parseArray(mode.getAuthIds());
			break;
		case REQ_PERM: //根据单个权限进行鉴权
			if(userService.checkPerm(user, mode.getAuthId())) authAccept = true;
			authMsg = mode.getAuthId();
			break;
		case REQ_PERMS: //根据多个权限进行鉴权（全部满足）
			if(userService.checkPerms(user, mode.getAuthIds())) authAccept = true;
			authMsg = EStr.parseArray(mode.getAuthIds());
			break;
		case REQ_PERMS_ANY: //根据多个权限进行鉴权（满足任意）
			if(userService.checkPermsAny(user, mode.getAuthIds())) authAccept = true;
			authMsg = EStr.parseArray(mode.getAuthIds());
			break;
		case REQ_LOGIN: //根据用户的登录状态进行鉴权
			authAccept = logined;
			break;
		case REQ_GUEST: //允许匿名
			authAccept = true;
			break;
		default:
			break;
		}
		
		return authAccept ? ERet.ok() : ERet.fail(authMsg);
	}
	
}
