package itez.core.runtime.auth;

public enum AuthCode {

	REQ_LICENSE(100, "需要功能许可"), //要求功能许可
	REQ_LOGIN(200, "请先登录"), //要求登录
	REQ_PERM(301, "需要更多的操作权限"), //要求权限
	REQ_PERMS(302, "需要更多的操作权限"), //要求全部权限
	REQ_PERMS_ANY(303, "需要更多的操作权限"), //要求任意权限
	REQ_ROLE(401, "需要更多的用户角色"), //要求角色
	REQ_ROLES(402, "需要更多的用户角色"), //要求全部角色
	REQ_ROLES_ANY(403, "需要更多的用户角色"), //要求任意角色
	REQ_GUEST(500, "允许匿名操作"), //允许匿名访问
	LOGIC(600, "业务逻辑错误，请检查操作是否符合要求"), //用户操作逻辑错误
	RUNTIME(700, "抱歉！服务器端发生未知错误"); //运行时未知错误
	
	private int code;
	private String msg;

	private AuthCode(int code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}
	
	public String getMsg(){
		return msg;
	}
	
	public void setMsg(String msg){
		this.msg = msg;
	}
	
}
