package itez.core.runtime;

import javax.servlet.http.HttpServletResponse;

import itez.core.runtime.session.EAttr;
import itez.core.runtime.session.EServletRequestWrapper;
import itez.core.runtime.session.ESessionBase;
import itez.core.wrapper.controller.EController;

/**
 * JWinner上下文线程处理
 * 将会话中经常使用的相关对象绑定到线程，方便在各层随时调用
 * 
 * @author netwild
 *
 */
public class EContext {

	private static ThreadLocal<EController> controllers = new ThreadLocal<>();
	private static ThreadLocal<EServletRequestWrapper> requests = new ThreadLocal<>();
	private static ThreadLocal<HttpServletResponse> responses = new ThreadLocal<>();
	private static ThreadLocal<EAttr> attrs = new ThreadLocal<>();
	
	public static void bind(EController controller, EServletRequestWrapper request, HttpServletResponse response){
		bind(controller);
		bind(request, response);
	}
	
	public static void bind(EController controller) {
		controllers.set(controller);
	}

	public static void bind(EServletRequestWrapper request, HttpServletResponse response) {
		requests.set(request);
		responses.set(response);
	}
	
	public static void bind(EAttr attr) {
		attrs.set(attr);
	}
	
	public static EController getController(){
		return controllers.get();
	}
	
	public static EServletRequestWrapper getRequest(){
		return requests.get();
	}
	
	public static HttpServletResponse getResponse(){
		return responses.get();
	}
	
	public static EAttr getAttr(){
		return attrs.get();
	}
	
	public static ESessionBase getSession(){
		return getRequest().session(true);
	}
	
	public static void release(){
		controllers.remove();
		requests.remove();
		responses.remove();
	}
	
	public static void releaseAttr(){
		attrs.remove();
	}
	
    @SuppressWarnings("unchecked")
	public static <T> T getRequestAttr(String key) {
    	EServletRequestWrapper request = requests.get();
        if (request == null) return null;
        return (T) request.getAttribute(key);
    }

    public static void setRequestAttr(String key, Object value) {
    	EServletRequestWrapper request = requests.get();
        if (request == null) return;
        request.setAttribute(key, value);
    }
	
}
