package itez.core.license;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Map;

import com.beust.jcommander.internal.Maps;
import com.jfinal.kit.HashKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;

import itez.core.launch.JW;
import itez.kit.ECode;
import itez.kit.EDate;
import itez.kit.EJson;
import itez.kit.EStr;

@SuppressWarnings({"rawtypes", "unchecked"})
public class LicenseAuth {

	private static final String SALT = "1L2Z3DW4G5M6ZF7Z";
	private static final String KEY_SYS_CODE = "SysCode";
	private static final String KEY_SYS_CAPTION = "SysCaption";
	private static final String KEY_SYS_DISK = "SysDisk";
	private static final String KEY_SYS_EXPIRE = "SysExpire";
	private static final String KEY_SYS_LICENSE = "SysLicense";
	private static final Prop PROP = PropKit.use(JW.MainConfigName);
	
	public static String vali() throws LicenseException{
		String localCode = getLocalCode();
		String licenseCode = PROP.get("License");;
		if(EStr.isEmpty(licenseCode)) throw new LicenseException(LicenseException.Code.NOLICENSE, localCode);
		String licenseJson = ECode.AESDecode(licenseCode, SALT);
		if(licenseJson == null) throw new LicenseException(LicenseException.Code.ERROR, localCode);
		String expire = getExpire(licenseJson);
		if(expire == null) throw new LicenseException(LicenseException.Code.ERROR, localCode);
		String licenseHash = getLicense(licenseJson);
		if(licenseHash == null) throw new LicenseException(LicenseException.Code.ERROR, localCode);
		String licenseLogic = getLocalLicense(expire);
		if(!licenseLogic.equals(licenseHash)) throw new LicenseException(LicenseException.Code.ERROR, localCode);
		Date date = EDate.getDate();
		Date expi = EDate.parse(expire);
		if(EDate.diff(date, expi).toDays() < 0) throw new LicenseException(LicenseException.Code.EXPIRE, localCode);
		return expire;
	}
	
	private static String getExpire(String licenseJson){
		Map metas;
		try {
			metas = EJson.parse(licenseJson, Map.class);
		} catch (Exception e) {
			metas = Maps.newHashMap();
		}
		if(!metas.containsKey(KEY_SYS_EXPIRE)) return null;
		Object expire = metas.get(KEY_SYS_EXPIRE);
		if(expire == null) return null;
		return expire.toString();
	}
	
	private static String getLicense(String licenseJson){
		Map metas;
		try {
			metas = EJson.parse(licenseJson, Map.class);
		} catch (Exception e) {
			metas = Maps.newHashMap();
		}
		if(!metas.containsKey(KEY_SYS_LICENSE)) return null;
		Object license = metas.get(KEY_SYS_LICENSE);
		if(license == null) return null;
		return license.toString();
	}
	
	private static String getLocalLicense(String expire){
		Map metas = getLocalMeta();
		metas.put(KEY_SYS_EXPIRE, expire);
		String json = EJson.toJson(metas);
		return HashKit.md5(json.concat(SALT));
	}
	
	private static String getLocalCode(){
		Map metas = getLocalMeta();
		String json = EJson.toJson(metas);
		return ECode.AESEncode(json, SALT);
	}
	
	private static Map getLocalMeta(){
		Map<String, String> metas = Maps.newHashMap();
		metas.put(KEY_SYS_CODE, PROP.get(KEY_SYS_CODE));
		metas.put(KEY_SYS_CAPTION, PROP.get(KEY_SYS_CAPTION));
		metas.put(KEY_SYS_DISK, getIdentifier());
		return metas;
	}
	
	private static String getIdentifier(){
		String os = System.getProperty("os.name");
		String iden = "";
		if(os.toLowerCase().startsWith("win")){
			try {
				iden = getIdentifier4Windows();
			} catch (Exception e) {
				iden = "NOTGET-WIN";
			}
		}else{
			try {
				iden = getIdentifier4Linux();
			} catch (Exception e) {
				iden = "NOTGET-LINUX";
			}
		}
		return iden;
	}
	
	private static String getIdentifier4Windows() throws Exception {
		String result = "", key = "卷的序列号是", line;
		Process process = Runtime.getRuntime().exec("cmd /c dir C:");
		BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream(), "GBK"));
		while ((line = br.readLine()) != null) {
			int at = line.indexOf(key);
			if (at != -1) {
				result = line.substring(at + key.length(), line.length()).trim();
				break;
			}
		}
		br.close();
		return result;
	}
	
	private static String getIdentifier4Linux() throws Exception {
		String[] cmd = { "fdisk", "-l" };
		Process process = Runtime.getRuntime().exec(cmd);
		process.waitFor();
		BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
		StringBuffer sb = new StringBuffer();
		String line;
		while ((line = br.readLine()) != null) sb.append(line);
		String str1 = sb.toString();
		String str2 = str1.split("identifier:")[1].trim();
		String result = str2.split("Device Boot")[0].trim();
		br.close();
		return result;
	}
	
}
