package itez.core.launch;

import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

import com.jfinal.core.JFinalFilter;

import itez.core.license.LicenseAuth;
import itez.core.license.LicenseException;
import itez.core.license.LicenseException.Code;
import itez.kit.ELog;

public class JWinnerFilter extends JFinalFilter {

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		try {
			String expire = LicenseAuth.vali();
			JW.LicenseVali = true;
			ELog.info("JWinner授权有效[{}]", expire);
			super.init(filterConfig);
		} catch (LicenseException e) {
			Code ec = e.getErrCode();
			if(ec == Code.NOLICENSE){
				ELog.error("抱歉，您还未经过上游科技的授权，无法运行JWinner！");
			}else if(ec == Code.ERROR){
				ELog.error("抱歉，您的授权码错误，无法运行JWinner！");
			}else if(ec == Code.EXPIRE){
				ELog.error("抱歉，您的授权已过期，请重新申请！");
			}
			ELog.error("授权方式：通过您的 [本地码] 向上游科技获取 [授权码] ，将其添加到配置文件的 [License] 选项即可。");
			ELog.error("您的本地码 [" + e.getLocalCode() + "]");
			ELog.error("上游科技官网：www.itez.com.cn");
		}
	}
	
}
