package itez.ai.baidu.ocr.entity;

import java.util.Map;

import com.google.common.collect.Maps;

import itez.ai.baidu.ocr.asset.Granularity;
import itez.ai.baidu.ocr.asset.Lang;
import itez.ai.baidu.ocr.asset.ResultType;
import itez.ai.baidu.ocr.asset.WordsType;
import itez.kit.EStr;
import itez.kit.pic.EPicBase64;

public class Params {

	private String image;
	private String url;
	private Lang language_type;			//识别语言类型，默认为CHN_ENG。
	private Granularity recognize_granularity;	//是否定位单字符位置，big：不定位单字符位置，默认值；small：定位单字符位置
	private Boolean detect_direction;	//是否检测图像朝向，默认不检测。朝向是指输入图像是正常方向、逆时针旋转90/180/270度。
	private Boolean detect_language;	//是否检测语言，默认不检测。当前支持（中文、英语、日语、韩语）
	private Boolean probability;		//是否返回识别结果中每一行的置信度
	private Boolean vertexes_location;	//是否返回文字外接多边形顶点位置，不支持单字位置。默认为false
	private Boolean is_sync;			//是否同步返回识别结果。默认取值为“false”
	private String request_id;			//获取结果ID
	private ResultType result_type;		//返回结果类型。is_sync=true时在提交请求时指定该参数，否则在获取结果时指定该参数
	private WordsType words_type;		//手写数字识别；无此参数或传其它值 默认手写通用识别（目前支持汉字和英文）
	
	private String templateSign;		//自定义文字识别平台制作的模板的ID
	private Integer classifierId;		//分类器Id。这个参数和templateSign至少存在一个，优先使用templateSign。
	
	public static Params ByLocal(String path){
		String base64 = EPicBase64.localImageToBase64(path);
		Params o = new Params();
		o.image = base64;
		return o;
	}
	
	public static Params ByImage(String image){
		Params o = new Params();
		o.image = image;
		return o;
	}
	
	public static Params ByUrl(String url){
		Params o = new Params();
		o.url = url;
		return o;
	}
	
	public Map<String, String> parse(){
		Map<String, String> p = Maps.newHashMap();
		if(EStr.notEmpty(image)) p.put("image", image);
		if(EStr.notEmpty(url)) p.put("url", url);
		if(EStr.notEmpty(language_type)) p.put("language_type", language_type.name());
		if(EStr.notEmpty(recognize_granularity)) p.put("recognize_granularity", recognize_granularity.name());
		if(EStr.notEmpty(detect_direction)) p.put("detect_direction", detect_direction.toString());
		if(EStr.notEmpty(detect_language)) p.put("detect_language", detect_language.toString());
		if(EStr.notEmpty(probability)) p.put("probability", probability.toString());
		if(EStr.notEmpty(vertexes_location)) p.put("vertexes_location", vertexes_location.toString());
		if(EStr.notEmpty(words_type)) p.put("words_type", words_type.name());
		if(EStr.notEmpty(is_sync)) p.put("is_sync", is_sync.toString());
		if(EStr.notEmpty(request_id)) p.put("request_id", request_id);
		if(EStr.notEmpty(result_type)) p.put("result_type", result_type.name());
		if(EStr.notEmpty(templateSign)) p.put("templateSign", templateSign);
		if(EStr.notEmpty(classifierId)) p.put("classifierId", classifierId.toString());
		return p;
	}

	public String getImage() {
		return image;
	}

	public Params setImage(String image) {
		this.image = image;
		return this;
	}

	public String getUrl() {
		return url;
	}

	public Params setUrl(String url) {
		this.url = url;
		return this;
	}

	public Lang getLanguage_type() {
		return language_type;
	}

	public Params setLanguage_type(Lang language_type) {
		this.language_type = language_type;
		return this;
	}

	public Boolean getDetect_direction() {
		return detect_direction;
	}

	public Params setDetect_direction(Boolean detect_direction) {
		this.detect_direction = detect_direction;
		return this;
	}

	public Boolean getDetect_language() {
		return detect_language;
	}

	public Params setDetect_language(Boolean detect_language) {
		this.detect_language = detect_language;
		return this;
	}

	public Boolean getProbability() {
		return probability;
	}

	public Params setProbability(Boolean probability) {
		this.probability = probability;
		return this;
	}

	public Boolean getVertexes_location() {
		return vertexes_location;
	}

	public Params setVertexes_location(Boolean vertexes_location) {
		this.vertexes_location = vertexes_location;
		return this;
	}

	public Granularity getRecognize_granularity() {
		return recognize_granularity;
	}

	public Params setRecognize_granularity(Granularity recognize_granularity) {
		this.recognize_granularity = recognize_granularity;
		return this;
	}

	public WordsType getWords_type() {
		return words_type;
	}

	public Params setWords_type(WordsType words_type) {
		this.words_type = words_type;
		return this;
	}

	public Boolean getIs_sync() {
		return is_sync;
	}

	public Params setSync(Boolean is_sync) {
		this.is_sync = is_sync;
		return this;
	}

	public String getRequest_id() {
		return request_id;
	}

	public Params setRequest_id(String request_id) {
		this.request_id = request_id;
		return this;
	}

	public ResultType getResult_type() {
		return result_type;
	}

	public Params setResult_type(ResultType result_type) {
		this.result_type = result_type;
		return this;
	}

	public String getTemplateSign() {
		return templateSign;
	}

	public Params setTemplateSign(String templateSign) {
		this.templateSign = templateSign;
		return this;
	}

	public Integer getClassifierId() {
		return classifierId;
	}

	public Params setClassifierId(Integer classifierId) {
		this.classifierId = classifierId;
		return this;
	}
	
}
