package itez.ai.baidu.ocr;

import java.util.Map;
import java.util.concurrent.Callable;
import com.google.common.collect.Maps;

import itez.ai.baidu.ocr.entity.AccessToken;
import itez.ai.baidu.ocr.entity.Account;
import itez.core.util.RetryUtils;
import itez.kit.EHttp;

public class AccessTokenKit {

	private final static String SER_URL = "https://aip.baidubce.com/oauth/2.0/token?grant_type=client_credentials&client_id=%s&client_secret=%s";
	private final static Map<String, AccessToken> tokens = Maps.newConcurrentMap();
	
    public static AccessToken getAccessToken() {
    	Account account = AccountKit.getAccount();
    	if(account == null) throw new RuntimeException("OCR账号不存在");
    	String appId = account.getAppId();
    	AccessToken token = null;
    	if(tokens.containsKey(appId)){
    		token = tokens.get(appId);
    		if(token != null && token.isAvailable()) return token;
    	}
    	token = refreshToken(account);
    	if(token == null) throw new RuntimeException("无法获取到AccessToken");
    	tokens.put(appId, token);
    	return token;
    }
    
    private static AccessToken refreshToken(Account account){
    	String url = String.format(SER_URL, account.getApiKey(), account.getSecretKey());
        // 最多三次请求
        AccessToken result = RetryUtils.retryOnException(3, new Callable<AccessToken>() {
            @Override
            public AccessToken call() throws Exception {
                String json = EHttp.me.get(url);
                return new AccessToken(json);
            }
        });
        return result;
    }
	
}
