define(['kit', 'ez-modal', 'tableExport'], function(Kit, Modal){
	
	var service = {}
	
	service.options = {
		, code: null 				//QTable模型别名
		, data: null				//主数据JSON
		, context: null				//上下文数据JSON
		, title: null				//标题
		, paged: false				//是否分页
		, queryParams: null			//需要保持的页面参数
		, checkbox: true			//是否显示第一列的选择框
		, checkId: 'id'				//第一列选择框绑定的字段名称
		, search: false				//是否启用关键字搜索
		, exportExcel: false		//是否启用导出Excel
		, columns: []				//字段配置
		, btnDetail: { used: true, caption: '详细', className: 'btn btn-warning btn-sm', icon: 'fa fa-ellipsis-h', callback: null }
		, btnAdd: { used: true, caption: '增加', className: 'btn btn-success btn-sm', icon: 'fa fa-asterisk', callback: null }
		, btnModify: { used: true, caption: '修改', className: 'btn btn-warning btn-sm', icon: 'fa fa-pencil-square-o', callback: null }
		, btnRemove: { used: true, caption: '删除', className: 'btn btn-warning btn-sm', icon: 'fa fa-trash-o', callback: null }
		, btnSortUp: { used: false, caption: '上移', className: 'btn btn-warning btn-sm', icon: 'fa fa-arrow-up', callback: null }
		, btnSortDown: { used: false, caption: '下移', className: 'btn btn-warning btn-sm', icon: 'fa fa-arrow-down', callback: null }
	}

	service.columnsOptions = {
        field: null
        , title: null
        , visible: true
        , align: 'left'
        , width: null
        , minWidth: null
        , maxWidth: null
        , detailVisible: true
        , formatter: function(value, row, context) { if(Kit.notEmpty(value)) return value; else return '' }
	}

	service.attr = {
		params: { pageNumber: 1, pageSize: 20, totalRow: 0, totalPage: 0, firstPage: false, lastPage: false }
		, boxHeader: null
		, boxBody: null
		, boxControls: null
		, boxTable: null
		, boxFooter: null
		, modalDetail: null
	}
		
    service.load = function(opts, callback){
		var me = this;
		$.extend(true, me.options, opts);
		me.attr.callback = callback;
		if(me.options.data === null){
			if(me.options.url === null){
				alert('未设置数据加载来源！');
				return;
			}else{
				$.get(url, function(data,status){
					if(status !== 'success'){
						alert('数据加载错误！');
						return;
					}else{
						me.options.data = data;
						me.render();
					}
				})
			}
		}else{
			me.render();
			return me;
		}
	}
	
	return service;
	
});