define(['store', 'kit', 'ez-validator'], function(Store, Kit, Vali){
	
	var service = {
		mySkins: ['skin-blue', 'skin-red', 'skin-yellow', 'skin-green']
	}
	
	service.changeSkin = function(cls){
		var me = this;
		$.each(me.mySkins, function (i) { $('body').removeClass(me.mySkins[i]) });
		$('body').addClass(cls);
		Store.set('JW_SKIN', cls);
	}
	
	service.goodUi = function(){
		//初始化iCheck
		$("input[type='checkbox']:not(.custom)").iCheck({ checkboxClass : "icheckbox_square-blue", increaseArea : "20%" });
		$("input[type='radio']:not(.custom)").iCheck({ radioClass : "iradio_square-blue", increaseArea : "20%" });
		//初始化操作提示框
		$('[data-toggle="tooltip"]').tooltip();
		//使用select2插件
		$(".select2").select2();
		//使用slider插件
		$(".slider").slider({ id: 'blue', tooltip: 'always', tooltip_position:'bottom' });
	}
	
	service.setup = function(){
		var me = this;
		
		//左侧树形
		$('.sidebar-menu').tree();
		
		//初始化页面主题
		var skin = Store.get("JW_SKIN");
		if(Kit.isEmpty(skin)) skin = "skin-blue";
		if (skin && $.inArray(skin, me.mySkins)) me.changeSkin(skin);
		$("[data-skin]").on("click", function (e) { e.preventDefault(); me.changeSkin($(this).data("skin")); })
		
		//初始化菜单显示
		var sidebarCls = 'sidebar-collapse';
		var sidebar = Store.get('JW_SIDEBAR');
		if(sidebar === 'close') $(document.body).addClass(sidebarCls);
		$('.sidebar-toggle').on('click', function(){ Store.set('JW_SIDEBAR', $(document.body).hasClass(sidebarCls)? 'open' : 'close'); });
		
		//默认加载表单校验器
		Vali.bindFormVali();
	};
	
	service.setup();
	service.goodUi();
	
	return {}
	
});
	  