require(['bootstrap', 'ez-lte', 'kit', 'ez-validator', 'store', 'select2', 'icheck', 'slider'], function(Bt, Lte, Kit, Vali, store){
	
	var mySkins = ['skin-blue', 'skin-red', 'skin-yellow', 'skin-green'];
		
	var changeSkin = function(cls){
		$.each(mySkins, function (i) { $('body').removeClass(mySkins[i]) });
		$('body').addClass(cls);
		store.set('JW_SKIN', cls);
	}

	var setup = function(){
		//默认样式
		Lte.init();
		//默认加载表单校验器
		Vali.bindFormVali(); 		
		//初始化页面主题
		var skin = store.get("JW_SKIN");
		if(Kit.isEmpty(skin)) skin = "skin-blue";
		if (skin && $.inArray(skin, mySkins)) changeSkin(skin);
		$("[data-skin]").on("click", function (e) { e.preventDefault(); changeSkin($(this).data("skin")); })
		
		//初始化菜单显示
		var sidebarCls = 'sidebar-collapse';
		var sidebar = store.get('JW_SIDEBAR');
		if(sidebar === 'close') $(document.body).addClass(sidebarCls);
		$('.sidebar-toggle').on('click', function(){ store.set('JW_SIDEBAR', $(document.body).hasClass(sidebarCls)? 'open' : 'close'); });
		
		$('a.fullscreen').on('click', function () {
            var doc = document.documentElement;
            if ($(document.body).hasClass("full-screen")) {
                $(document.body).removeClass("full-screen");
                document.exitFullscreen ? document.exitFullscreen() : document.mozCancelFullScreen ? document.mozCancelFullScreen() : document.webkitExitFullscreen && document.webkitExitFullscreen();
            } else {
                $(document.body).addClass("full-screen");
                doc.requestFullscreen ? doc.requestFullscreen() : doc.mozRequestFullScreen ? doc.mozRequestFullScreen() : doc.webkitRequestFullscreen ? doc.webkitRequestFullscreen() : doc.msRequestFullscreen && doc.msRequestFullscreen();
            }
        });
	};
	
	var goodUi = function(){
		//初始化iCheck
		$("input[type='checkbox']:not(.custom)").iCheck({ checkboxClass : "icheckbox_square-blue", increaseArea : "20%" });
		$("input[type='radio']:not(.custom)").iCheck({ radioClass : "iradio_square-blue", increaseArea : "20%" });
		//初始化操作提示框
		$('[data-toggle="tooltip"]').tooltip();
		//使用select2插件
		$(".select2").select2();
		//使用slider插件
		$(".slider").slider({ id: 'blue', tooltip: 'always', tooltip_position:'bottom' });
	}
	
	setup();
	goodUi();
	
});