define(['kit', 'jquery'], function(Kit){
	
	var renderDemo = function(index){
		var box = $('.excel-sheet-demo');
		box.empty();
		var sheetData = excel.sheets[index];
		var thead = $('<thead></thead');
		box.append(thead);
		var trh = $('<tr></tr>');
		thead.append(trh);
		for(var i=0; i<sheetData.cellCount; i++){
			var th = $('<th class="text-center bg-aqua">cells[' + i + ']</th>');
			trh.append(th);
		}
		var tbody = $('<tbody></tbody>');
		box.append(tbody);
		$.each(sheetData.rows, function(rowInd, rowItem){
			var row = $('<tr></tr>');
			tbody.append(row);
			$.each(rowItem.cells, function(cellInd, cellItem){
				var td = $('<td>' + cellItem.value + '</td>');
				row.append(td);
			})
		});
	}
	
	$('.sheetIndex').on('change', function(e){
		renderDemo($(this).val());
	});
	
	$('.inp-mode').on('change', function(e){
		var me = $(this);
		var mode = me.val();
		var ind = me.data('ind');
		var expr = $('.inp-expr[data-ind="' + ind + '"]');
		if(mode === 'excel'){
			expr.val('#(cells[列序号].value)');
			expr[0].focus();
			expr[0].setSelectionRange(8, 11);
		}else if(mode === 'const'){
			expr.val('""');
			expr[0].focus();
			expr[0].setSelectionRange(1, 1);
		}else if(mode === 'null'){
			expr.val('');
		}else if(mode === 'index'){
			expr.val('#(index)');
		}else{
			expr.val('"' + mode + '"');
		}
	});
	
	$('.applyCache').on('ifChanged', function(){
		if($(this).prop('checked')) $('.import-opts-box').addClass('hide');
		else $('.import-opts-box').removeClass('hide');
	});
	
	renderDemo(0);
	
});