/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.source.plugins.rdb.database;

import com.jfinal.plugin.activerecord.ActiveRecordPlugin;
import com.jfinal.plugin.activerecord.cache.ICache;
import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.DbProp;
import itez.core.wrapper.dbo.dialect.EDialect;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.core.wrapper.dbo.plugin.EActiveRecordPlugin;
import itez.core.wrapper.dbo.plugin.EDruidPlugin;
import itez.kit.ERet;
import itez.kit.EStr;
import itez.kit.cache.ECacheFactory;
import itez.plat.source.model.DataBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataBaseService
extends EModelService<DataBase> {
    private static final Map<String, EDruidPlugin> druids = new ConcurrentHashMap<String, EDruidPlugin>();
    private static final Map<String, ActiveRecordPlugin> arps = new ConcurrentHashMap<String, ActiveRecordPlugin>();

    public DataBase getDataBase(String id) {
        return (DataBase)this.findById(id);
    }

    public List<DataBase> getDataBases(String ids) {
        Querys qs = Querys.and((Query)Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs);
    }

    public DataBase getDataBaseByCode(String code) {
        Querys qs = Querys.and((Query)Query.eq((String)"code", (Object)code)).add(Query.eq((String)"used", (Object)1));
        DataBase db = (DataBase)this.selectFirst(qs);
        db.put("isStarted", this.getDataBaseStatus(db.getCode()));
        return db;
    }

    public List<DataBase> getAllDataBase() {
        Querys qs = Querys.and((Query)Query.eq((String)"used", (Object)1));
        List dbs = this.select(qs, null, null, new String[]{"id, code, caption, summary, dbType, dbDriverClass, dbUrl, dbUserName, dbInitialSize, dbMinIdle, dbMaxActive, autoRun, allowCreateTable, accessLevel"});
        dbs.forEach(db -> db.put("isStarted", this.getDataBaseStatus(db.getCode())));
        return dbs;
    }

    public Boolean getDataBaseStatus(String code) {
        if (druids.containsKey(code)) {
            return druids.get(code).isStarted();
        }
        return false;
    }

    public boolean startDataBase(String code) {
        if (druids.containsKey(code)) {
            EDruidPlugin druid = druids.get(code);
            if (druid.isStarted()) {
                return true;
            }
            druid.start();
            EActiveRecordPlugin arp = new EActiveRecordPlugin(code, druid.getDataSource());
            arp.setCache((ICache)ECacheFactory.me.getCache());
            arp.setDialect(EDialect.parseDialect((EDialect.DbType)druid.getDbType()));
            arp.start();
            arps.put(code, (ActiveRecordPlugin)arp);
            return true;
        }
        DataBase db = this.getDataBaseByCode(code);
        DbProp prop = new DbProp();
        prop.setConnName(code);
        prop.setType(EDialect.DbType.fromString((String)db.getDbType()));
        prop.setDriverClass(db.getDbDriverClass());
        prop.setJdbcUrl(db.getDbUrl());
        prop.setUserName(db.getDbUserName());
        prop.setPassWord(db.getDbPassWord());
        prop.setInitialSize(db.getDbInitialSize());
        prop.setMinIdle(db.getDbMinIdle());
        prop.setMaxActive(db.getDbMaxActive());
        EDruidPlugin druid = new EDruidPlugin(prop, true);
        boolean start = druid.start();
        if (!start) {
            return false;
        }
        EActiveRecordPlugin arp = new EActiveRecordPlugin(code, druid.getDataSource());
        arp.setCache((ICache)ECacheFactory.me.getCache());
        arp.setDialect(EDialect.parseDialect((EDialect.DbType)druid.getDbType()));
        start = arp.start();
        if (!start) {
            druid.stop();
            return false;
        }
        druids.put(code, druid);
        arps.put(code, (ActiveRecordPlugin)arp);
        return true;
    }

    public void stopDataBase(String code) {
        if (!druids.get(code).isStarted()) {
            return;
        }
        arps.get(code).stop();
        druids.get(code).stop();
    }

    public void startAllDataBase() {
        List<DataBase> dbs = this.getAllDataBase();
        dbs.forEach(db -> this.startDataBase(db.getCode()));
    }

    public void stopAllDataBase() {
        List<DataBase> dbs = this.getAllDataBase();
        dbs.forEach(db -> this.stopDataBase(db.getCode()));
    }

    public boolean update(DataBase model) {
        boolean ret;
        boolean run = false;
        String code = model.getCode();
        if (this.getDataBaseStatus(code).booleanValue()) {
            run = true;
            this.stopDataBase(code);
            druids.remove(code);
            arps.remove(code);
        }
        if ((ret = super.update((EModel)model)) && run) {
            ret = this.startDataBase(code);
        }
        return ret;
    }

    public List<ERet> getDbTypeList() {
        ArrayList<ERet> list = new ArrayList<ERet>();
        list.add(ERet.create((Object)"value", (Object)EDialect.DbType.mysql.name()).set((Object)"text", (Object)"MySQL"));
        list.add(ERet.create((Object)"value", (Object)EDialect.DbType.postgresql.name()).set((Object)"text", (Object)"PostgreSQL"));
        list.add(ERet.create((Object)"value", (Object)EDialect.DbType.oracle.name()).set((Object)"text", (Object)"Oracle"));
        list.add(ERet.create((Object)"value", (Object)EDialect.DbType.sqlserver.name()).set((Object)"text", (Object)"SqlServer"));
        return list;
    }

    public void remove(String ids) {
        List<DataBase> list = this.getDataBases(ids);
        list.forEach(item -> {
            String code = item.getCode();
            if (this.getDataBaseStatus(code).booleanValue()) {
                this.stopDataBase(code);
                druids.remove(code);
                arps.remove(code);
            }
            item.disable();
        });
    }
}

