/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.site.model;

import com.jfinal.plugin.activerecord.Page;
import itez.core.runtime.EContext;
import itez.core.runtime.service.Ioc;
import itez.plat.site.model.Content;
import itez.plat.site.model.base.BaseChannel;
import itez.plat.site.service.ChannelService;
import itez.plat.site.service.ContentService;
import java.util.List;

public class Channel
extends BaseChannel<Channel> {
    private static final ChannelService channelSer = (ChannelService)Ioc.get(ChannelService.class);
    private static final ContentService contentSer = (ContentService)Ioc.get(ContentService.class);

    public String url() {
        String code = this.getCode();
        if (code.equals("Index")) {
            return EContext.getAttr().getSrc();
        }
        return String.format("%s/%s/%s", EContext.getAttr().getSrc(), "channel", this.getCode());
    }

    public Channel by(String code) {
        return (Channel)channelSer.findByCode(code);
    }

    public Channel index() {
        return channelSer.getIndexChannel();
    }

    public Channel parent() {
        String code = this.getCode();
        if (code.equals("Index")) {
            return null;
        }
        return (Channel)channelSer.findById(this.getPid());
    }

    public List<Channel> children() {
        return channelSer.getChildren(this.getId());
    }

    public Content first() {
        return contentSer.first(this.getId());
    }

    public Content last() {
        return contentSer.last(this.getId());
    }

    public List<Content> list() {
        return this.list(null, true, false);
    }

    public List<Content> list(Integer count) {
        return this.list(count, true, false);
    }

    public List<Content> list(Integer count, Boolean desc) {
        return this.list(count, desc, false);
    }

    public List<Content> list(Integer count, Boolean desc, Boolean children) {
        if (children.booleanValue()) {
            List<String> ids = channelSer.getChildrenIds(this.getId());
            return contentSer.getByChannelIds(ids, count, desc);
        }
        return contentSer.getByChannelId(this.getId(), count, desc);
    }

    public Page<Content> page(Integer pageNum, Integer pageSize, Boolean desc, Boolean children) {
        if (children.booleanValue()) {
            List<String> ids = channelSer.getChildrenIds(this.getId());
            return contentSer.getPageByChannelIds(ids, pageNum, pageSize, desc);
        }
        return contentSer.getPageByChannelId(this.getId(), pageNum, pageSize, desc);
    }

    public List<Content> search(String keyword, Boolean desc, Boolean children) {
        if (children.booleanValue()) {
            List<String> ids = channelSer.getChildrenIds(this.getId());
            return contentSer.searchByChannelIds(ids, keyword, desc);
        }
        return contentSer.searchByChannelId(this.getId(), keyword, desc);
    }
}

