/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EService;
import itez.core.runtime.service.IService;
import itez.kit.EDate;
import itez.kit.ELog;
import itez.kit.EStr;
import itez.plat.base.model.User;
import itez.plat.base.service.UserService;
import itez.weixin.api.ApiResult;
import itez.weixin.api.app.WxaUserApi;

@Define
@Singleton
public class UserWxServiceImpl
extends EService
implements IService {
    @Inject
    UserService us;

    public String wxAppLogin(String codeJs, String userInfo, String domain) throws Exception {
        String sid;
        block6: {
            sid = "";
            WxaUserApi api = new WxaUserApi();
            ApiResult ret = api.getSessionKey(codeJs);
            if (null != ret && ret.isSucceed()) {
                String openId = ret.getStr("openid");
                String unionId = ret.getStr("unionid");
                String sessionKey = ret.getStr("session_key");
                try {
                    JSONObject userJson;
                    User user = null;
                    if (EStr.notEmpty((String)unionId)) {
                        user = this.us.findByUnionId(unionId);
                    }
                    if (user == null) {
                        user = this.us.findByWxaOpenId(openId);
                    }
                    if (EStr.isEmpty((String)(sid = this.addUserWxApp(user, openId, unionId, sessionKey, domain, userJson = JSON.parseObject((String)userInfo))))) {
                        throw new Exception("\u7ef4\u62a4\u7528\u6237\u4fe1\u606f\u65f6\u53d1\u751f\u9519\u8bef");
                    }
                    break block6;
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
            throw new RuntimeException("\u8fd4\u56de\u9519\u8bef\uff1a" + ret.getErrorMsg());
        }
        return sid;
    }

    private String addUserWxApp(User user, String openId, String unionId, String sessionKey, String domain, JSONObject userJson) {
        String sid = "";
        if (null != userJson) {
            String nickName = userJson.getString("nickName");
            String avatarUrl = userJson.getString("avatarUrl");
            String gender = userJson.getString("gender");
            String province = userJson.getString("province");
            String city = userJson.getString("city");
            String country = userJson.getString("country");
            String language = userJson.getString("language");
            if (user == null) {
                user = new User();
                user.setWxaOpenId(openId);
                user.setUnionId(unionId);
                user.setWxaSessionKey(sessionKey);
                user.setDomain(domain);
                user.setCaption(nickName);
                user.setHeader(avatarUrl);
                user.setSex(gender);
                user.setCountry(country);
                user.setProvince(province);
                user.setCity(city);
                user.setLanguage(language);
                user.setSalt(HashKit.generateSaltForSha256());
                user.setLevel(0);
                user.setMember(0);
                user.setFollowed(1);
                user.setFollowDate(EDate.getDate());
                user.save();
                sid = user.getId();
                ELog.info((String)"\u5c0f\u7a0b\u5e8f\u65b0\u7528\u6237\uff1a{}\uff08openid\uff1a{}\uff09", (Object[])new Object[]{nickName, openId});
            } else {
                sid = user.getId();
                user.setWxaSessionKey(sessionKey);
                user.setCaption(nickName);
                user.setHeader(avatarUrl);
                user.setUnionId(unionId);
                user.update();
                ELog.info((String)"\u5c0f\u7a0b\u5e8f\u8001\u7528\u6237\uff1a{}\uff08openid\uff1a{}\uff09", (Object[])new Object[]{nickName, openId});
            }
        }
        return sid;
    }

    @Cache.del(cache="USER_BY_ID", key="#(userId)")
    public void setWxaFormId(String userId, String formId) {
        User user = (User)this.us.findById(userId);
        ((User)user.set("wxaFormId", formId)).update();
    }

    public String getWxaFormId(String userId) {
        return ((User)this.us.findById(userId)).getWxaFormId();
    }
}

