/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.jfinal.kit.HashKit;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;
import itez.plat.base.model.User;
import itez.plat.base.service.PermService;
import itez.plat.base.service.RoleService;
import itez.plat.base.service.UserIOService;
import itez.plat.base.service.UserService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Define
@Singleton
public class UserServiceImpl
extends EModelService<User>
implements UserService,
IUserService {
    @Inject
    UserIOService uioService;
    @Inject
    RoleService roleService;
    @Inject
    PermService permService;
    private User emptyUser = new User();

    public UserServiceImpl() {
        this.emptyUser.setId(null);
        this.emptyUser.setCaption("\u533f\u540d\u7528\u6237");
        this.emptyUser.setUsed(1);
    }

    public User getEmptyUser() {
        return this.emptyUser;
    }

    @Cache.able(cache="USER_BY_ID", key="#(userId)")
    public User findById(String userId) {
        return (User)super.findById(userId);
    }

    @Cache.able(cache="USER_BY_EMAIL", key="#(email)")
    public User findByEmail(String email) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"email", (Object)email)));
    }

    @Cache.able(cache="USER_BY_PHONE", key="#(phone)")
    public User findByPhone(String phone) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"phone", (Object)phone)));
    }

    @Cache.able(cache="USER_BY_LOGIN", key="#(domain).#(loginName)")
    public User findByLogin(String domain, String loginName) {
        Querys qs1 = Querys.or((Query)Query.eq((String)"domain", (Object)domain)).add(Query.eq((String)"level", (Object)2));
        Querys qs2 = Querys.and((Querys)qs1).add(Query.eq((String)"loginName", (Object)loginName));
        List users = this.select(qs2, null, 1, false, new String[0]);
        return users.size() > 0 ? (User)((Object)users.get(0)) : null;
    }

    public User findByLogin(String domain, String loginName, String passWord) {
        String pass;
        User user = this.findByLogin(domain, loginName);
        if (user != null && (pass = HashKit.md5((String)String.format("%s%s", passWord, user.getSalt()))).equals(user.getLoginPass())) {
            return user;
        }
        return null;
    }

    public boolean checkRole(IUser user, String roleCode) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (EStr.isEmpty((String)roleCode)) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        return roles.stream().anyMatch(r -> r.getCode().equals(roleCode));
    }

    public boolean checkRoles(IUser user, String ... roleCodeArr) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (roleCodeArr == null || roleCodeArr.length == 0) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        Set rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
        HashSet<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
        rolesHas.add(this.$UUID());
        if (!rolesHas.retainAll(rolesReq)) {
            return false;
        }
        return rolesReq.size() == rolesHas.size();
    }

    public boolean checkRolesAny(IUser user, String ... roleCodeArr) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (roleCodeArr == null || roleCodeArr.length == 0) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        Set rolesHas = roles.stream().map(r -> r.getCode()).collect(Collectors.toSet());
        HashSet<String> rolesReq = new HashSet<String>(Arrays.asList(roleCodeArr));
        rolesHas.add(this.$UUID());
        return rolesHas.retainAll(rolesReq);
    }

    public boolean checkPerm(IUser user, String permCode) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (EStr.isEmpty((String)permCode)) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        String[] permIds = (String[])roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
        if (permIds == null || permIds.length == 0) {
            return false;
        }
        List perms = this.permService.findByIda(permIds);
        if (perms == null || perms.size() == 0) {
            return false;
        }
        return perms.stream().anyMatch(p -> p.getCode().equals(permCode));
    }

    public boolean checkPerms(IUser user, String ... permCodeArr) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (permCodeArr == null || permCodeArr.length == 0) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        String[] permIds = (String[])roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
        if (permIds == null || permIds.length == 0) {
            return false;
        }
        List perms = this.permService.findByIda(permIds);
        if (perms == null || perms.size() == 0) {
            return false;
        }
        Set permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
        HashSet<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
        permsHas.add(this.$UUID());
        if (!permsHas.retainAll(permsReq)) {
            return false;
        }
        return permsReq.size() == permsHas.size();
    }

    public boolean checkPermsAny(IUser user, String ... permCodeArr) {
        if (user.getLevel() == 2) {
            return true;
        }
        if (permCodeArr == null || permCodeArr.length == 0) {
            return true;
        }
        User u = (User)user;
        String roleIds = u.getRoleIds();
        if (EStr.isEmpty((String)roleIds)) {
            return false;
        }
        List roles = this.roleService.findByIda(EStr.toArray((String)roleIds));
        if (roles == null || roles.size() == 0) {
            return false;
        }
        String[] permIds = (String[])roles.stream().map(r -> r.getPermIds().split(",")).flatMap(Arrays::stream).distinct().toArray(String[]::new);
        if (permIds == null || permIds.length == 0) {
            return false;
        }
        List perms = this.permService.findByIda(permIds);
        if (perms == null || perms.size() == 0) {
            return false;
        }
        Set permsHas = perms.stream().map(p -> p.getCode()).collect(Collectors.toSet());
        HashSet<String> permsReq = new HashSet<String>(Arrays.asList(permCodeArr));
        permsHas.add(this.$UUID());
        return permsHas.retainAll(permsReq);
    }

    @Override
    public List<User> getUsers(String domain, String ids) {
        Querys qs = Querys.and((Query)Query.eq((String)"domain", (Object)domain)).add(Query.in((String)"id", (String)EStr.ids2sqlIn((String)ids)));
        return this.select(qs);
    }

    @Override
    public List<User> getInsUsers(String domain, String deptId) {
        Querys qs = Querys.and((Query)Query.eq((String)"member", (Object)1)).add(Query.eq((String)"domain", (Object)domain)).add(Query.eq((String)"deptId", (Object)deptId)).add(Query.eq((String)"used", (Object)1)).add(Query.ne((String)"level", (Object)2));
        List list = this.select(qs, "level desc, id", null, new String[]{"id, caption, loginName, roleIds"});
        return list;
    }

    @Override
    public void add(User user, String loginPass) {
        this.uioService.addUser(user, loginPass);
    }

    @Override
    public void modify(User user) {
        this.uioService.modifyUser(user);
    }

    @Override
    public void remove(String domain, String ids) {
        List<User> users = this.getUsers(domain, ids);
        users.forEach(user -> this.uioService.removeUser((User)((Object)user)));
    }

    @Override
    public User findByUnionId(String unionId) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"unionId", (Object)unionId)));
    }

    @Override
    public User findByWxOpenId(String openId) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"wxOpenId", (Object)openId)));
    }

    @Override
    public User findByWxaOpenId(String openId) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"wxaOpenId", (Object)openId)));
    }

    @Override
    public User findByWxeOpenId(String openId) {
        return (User)super.selectFirst(Querys.and((Query)Query.eq((String)"wxeOpenId", (Object)openId)));
    }

    @Override
    public User loginByTypeName(String type, String loginName) {
        Querys qs = Querys.and((Query)Query.eq((String)"type", (Object)type)).add(Query.eq((String)"loginName", (Object)loginName));
        return (User)this.selectFirst(qs);
    }

    @Override
    public User loginByTypeNameOrIdNum(String type, String loginName) {
        Querys qs1 = Querys.or((Query)Query.eq((String)"idNum", (Object)loginName)).add(Query.eq((String)"loginName", (Object)loginName));
        Querys qs2 = Querys.and((Query)Query.eq((String)"type", (Object)type)).add(qs1);
        return (User)this.selectFirst(qs2);
    }
}

