/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.service.impl;

import com.google.inject.Singleton;
import itez.core.runtime.cache.Cache;
import itez.core.runtime.modules.ModuleBase;
import itez.core.runtime.modules.ModuleManager;
import itez.core.runtime.service.Define;
import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.ELog;
import itez.kit.exception.ErrException;
import itez.kit.log.ELogBase;
import itez.plat.base.model.Module;
import itez.plat.base.service.ModuleService;
import java.util.List;
import java.util.Map;

@Define
@Singleton
public class ModuleServiceImpl
extends EModelService<Module>
implements ModuleService {
    private static final ELogBase log = ELog.log(ModuleService.class);

    @Cache.able(cache="moduleService", key="#(id)")
    public Module findById(String id) {
        return (Module)super.findById(id);
    }

    @Cache.able(cache="moduleService", key="#(code)")
    public Module findByCode(String code) {
        return (Module)super.findByCode(code);
    }

    @Override
    @Cache.put(cache="moduleService", key="#(module.key)")
    public Module create(Module module) {
        if (super.save((EModel)module)) {
            return module;
        }
        throw new ErrException("\u521b\u5efa\u6a21\u5757\u5931\u8d25");
    }

    @Cache.del(cache="moduleService", key="#(module.key)")
    public boolean disable(Module module) {
        if (super.disable((EModel)module)) {
            return true;
        }
        throw new ErrException("\u505c\u7528\u6a21\u5757\u5931\u8d25");
    }

    @Cache.del(cache="moduleService", key="#(module.key)")
    public boolean enable(Module module) {
        if (super.enable((EModel)module)) {
            return true;
        }
        throw new ErrException("\u542f\u7528\u6a21\u5757\u5931\u8d25");
    }

    @Cache.able
    public List<Module> findByIda(String ... ids) {
        return super.findByIda(ids);
    }

    @Override
    public void initModuleData() {
        List oldList = this.selectAll();
        Map map = ModuleManager.me.getModules();
        oldList.stream().forEach(m -> {
            if (!map.containsKey(m.getCode())) {
                this.disable((Module)((Object)m));
                log.info("\u505c\u7528\u6a21\u5757\uff1a{} - {}", new Object[]{m.getCode(), m.getCaption()});
            } else {
                ModuleBase m_cfg = (ModuleBase)map.get(m.getCode());
                m.setCaption(m_cfg.getModuleName());
                m.setPath(m_cfg.getModulePath());
                this.update((EModel)m);
            }
        });
        map.forEach((code, cfg) -> {
            Module m;
            List ms = this.select(Querys.and((Query)Query.eq((String)"code", (Object)code)), null, 1, false, new String[0]);
            Module module = m = ms.size() > 0 ? (Module)((Object)((Object)ms.get(0))) : null;
            if (m == null) {
                m = new Module();
                m.setCode((String)code);
                m.setPath(cfg.getModulePath());
                m.setCaption(cfg.getModuleName());
                this.create(m);
                log.info("\u53d1\u73b0\u65b0\u6a21\u5757\uff1a{} - {}", new Object[]{code, cfg.getModuleName()});
            } else if (!m.able()) {
                this.enable(m);
                log.info("\u91cd\u65b0\u542f\u7528\u6a21\u5757\uff1a{} - {}", new Object[]{code, cfg.getModuleName()});
            }
        });
    }
}

