/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.model;

import itez.core.runtime.service.Ioc;
import itez.core.runtime.service.common.IUser;
import itez.core.runtime.service.common.IUserService;
import itez.plat.base.model.Dept;
import itez.plat.base.model.Post;
import itez.plat.base.model.PostLevel;
import itez.plat.base.model.Vert;
import itez.plat.base.model.base.BaseUser;
import itez.plat.base.service.DeptService;
import itez.plat.base.service.PostLevelService;
import itez.plat.base.service.PostService;
import itez.plat.base.service.VertService;
import java.math.BigDecimal;

public class User
extends BaseUser<User>
implements IUser {
    private final transient IUserService us = Ioc.getUser();
    private final transient DeptService ds = (DeptService)Ioc.get(DeptService.class);
    private final transient PostService ps = (PostService)Ioc.get(PostService.class);
    private final transient PostLevelService pls = (PostLevelService)Ioc.get(PostLevelService.class);
    private final transient VertService vs = (VertService)Ioc.get(VertService.class);

    public Dept getDept() {
        if (this.getDeptId() == null) {
            return null;
        }
        return (Dept)this.ds.findById(this.getDeptId());
    }

    public Post getPost() {
        if (super.getPostId() == null) {
            return null;
        }
        Post post = (Post)this.ps.findById(this.getPostId());
        return post;
    }

    public PostLevel getPostLevel() {
        Post post = this.getPost();
        if (post == null) {
            return null;
        }
        String plevelId = post.getLevelId();
        if (plevelId == null) {
            return null;
        }
        PostLevel plevel = (PostLevel)this.pls.findById(plevelId);
        return plevel;
    }

    public Vert getVert() {
        PostLevel plevel = this.getPostLevel();
        if (plevel == null) {
            return null;
        }
        String vertId = plevel.getVertId();
        if (vertId == null) {
            return null;
        }
        Vert vert = (Vert)this.vs.findById(vertId);
        return vert;
    }

    @Override
    public BigDecimal getCoef() {
        if (super.getCoef() != null) {
            return super.getCoef();
        }
        Post post = this.getPost();
        if (post == null) {
            return null;
        }
        return post.getCoef();
    }

    @Override
    public String getRoleIds() {
        if (super.getRoleIds() != null) {
            return super.getRoleIds();
        }
        Post post = this.getPost();
        if (post == null) {
            return null;
        }
        return post.getRoleIds();
    }

    public boolean checkRole(String roleCode) {
        return this.us.checkRole((IUser)this, roleCode);
    }

    public boolean checkRoles(String ... roleCodeArr) {
        return this.us.checkRoles((IUser)this, roleCodeArr);
    }

    public boolean checkRolesAny(String ... roleCodeArr) {
        return this.us.checkRolesAny((IUser)this, roleCodeArr);
    }

    public boolean checkPerm(String permCode) {
        return this.us.checkPerm((IUser)this, permCode);
    }

    public boolean checkPerms(String ... permCodeArr) {
        return this.us.checkPerms((IUser)this, permCodeArr);
    }

    public boolean checkPermsAny(String ... permCodeArr) {
        return this.us.checkPermsAny((IUser)this, permCodeArr);
    }
}

