/*
 * Decompiled with CFR 0.152.
 */
package itez.plat.base.controller;

import com.google.inject.Inject;
import com.jfinal.kit.Kv;
import itez.core.runtime.auth.AuthRequire;
import itez.core.wrapper.controller.ControllerDefine;
import itez.kit.EStr;
import itez.plat.base.model.Menu;
import itez.plat.base.service.MenuService;
import itez.plat.wrapper.controller.EControllerMgr;
import java.util.List;

@ControllerDefine(key="/menu", summary="\u83dc\u5355\u7ba1\u7406", view="/")
@AuthRequire.Logined
public class MenuController
extends EControllerMgr {
    @Inject
    MenuService menuSer;

    public void index() {
        String mtype = this.getPara("mtype", "menu");
        String title = mtype.equals("menu") ? "\u4fa7\u680f\u83dc\u5355" : "\u9876\u680f\u5bfc\u822a";
        Kv rootMenu = Kv.by((Object)"id", (Object)"").set((Object)"caption", (Object)title).set((Object)"folder", (Object)1);
        List<Menu> menus = this.menuSer.getMenuTree(mtype);
        this.setAttr("mtype", mtype);
        this.setAttr("title", title);
        this.setAttr("pid", this.getPara("pid", null));
        this.setAttr("rootMenu", rootMenu);
        this.setAttr("menus", menus);
        this.render("menu.html");
    }

    public void add() {
        String mtype = this.getPara("mtype", "menu");
        String pid = this.getPara("pid");
        String ico = this.getPara("ico");
        String caption = this.getPara("caption");
        String command = this.getPara("command");
        String authMode = this.getPara("authMode");
        String authCode = this.getPara("authCode");
        Integer folder = this.getParaToInt("folder", 0);
        if (EStr.notNull((Object)authMode) && authMode.equals("-")) {
            authMode = null;
        }
        Menu parent = (Menu)this.menuSer.findById(pid);
        Menu last = this.menuSer.getLastMenu(mtype, pid);
        Integer sort = last == null ? 1 : last.getSort() + 1;
        String path = parent == null ? EStr.addPrefix((int)sort, (int)3) : String.format("%s_%s", parent.getPath(), EStr.addPrefix((int)sort, (int)3));
        Menu menu = new Menu();
        menu.setMtype(mtype);
        menu.setPid(EStr.ifEmpty((String)pid, null));
        menu.setIco(ico);
        menu.setCaption(caption);
        menu.setCommand(command);
        menu.setAuthMode(authMode);
        menu.setAuthCode(authCode);
        menu.setFolder(folder);
        menu.setSort(sort);
        menu.setPath(path);
        this.menuSer.save(menu);
        this.redirect(this.attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
    }

    public void modify() {
        String id = this.getPara("id");
        Menu menu = (Menu)this.menuSer.findById(id);
        String mtype = menu.getMtype();
        String pid = menu.getPid();
        String ico = this.getPara("ico");
        String caption = this.getPara("caption");
        String command = this.getPara("command");
        String authMode = this.getPara("authMode");
        String authCode = this.getPara("authCode");
        Integer folder = this.getParaToInt("folder", 0);
        if (EStr.notNull((Object)authMode) && authMode.equals("-")) {
            authMode = null;
        }
        menu.setIco(ico);
        menu.setCaption(caption);
        menu.setCommand(command);
        menu.setAuthMode(authMode);
        menu.setAuthCode(authCode);
        menu.setFolder(folder);
        this.menuSer.update(menu);
        this.redirect(this.attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
    }

    public void remove() {
        String mtype = this.getPara("mtype", "menu");
        String pid = this.getPara("pid");
        String ids = this.getPara("ids");
        this.menuSer.deleteByIds(ids);
        this.redirect(this.attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
    }

    public void sort() {
        String mtype = this.getPara("mtype", "menu");
        String pid = this.getPara("pid");
        String opt = this.getPara("opt");
        String ids = this.getPara("ids");
        this.menuSer.sort(mtype, pid, opt, ids);
        this.redirect(this.attr().getCtrl() + "?mtype=" + mtype + "&pid=" + pid);
    }
}

