package itez.plat.wrapper.service;

import java.util.List;

import itez.core.runtime.service.EModelService;
import itez.core.wrapper.dbo.model.EModel;
import itez.core.wrapper.dbo.model.Query;
import itez.core.wrapper.dbo.model.Querys;
import itez.kit.EStr;

public abstract class ETreeService<M extends EModel<M>> extends EModelService<M> {
	
	public M getLast(String pid){
		return getLast(null, pid);
	}
	
	public M getLast(Querys qs, String pid){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(Query.eq("pid", pid));
		return selectFirst(querys, "sort desc");
	}

	public M getPerv(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(Query.eq("pid", pid)).add(Query.lt("sort", sort));
		return selectFirst(querys, "sort desc");
	}

	public M getNext(Querys qs, String pid, Integer sort){
		Querys querys = Querys.and();
		if(qs != null) querys.add(qs);
		querys.add(Query.eq("pid", pid)).add(Query.gt("sort", sort));
		return selectFirst(querys, "sort");
	}
	
	public List<M> getByIds(String ids, String orderby){
		Querys qs = Querys.and(Query.in("id", EStr.ids2sqlIn(ids)));
		return select(qs, "sort " + orderby);
	}
	
	public void sort(String pid, String opt, String ids){
		sort(null, pid, opt, ids);
	}
	
	public void sort(Querys qs, String pid, String opt, String ids){
		List<M> list = getByIds(ids, opt.equals("up") ? "asc" : "desc");
		if(opt.equals("up")){
			M perv = getPerv(qs, pid, list.get(0).getInt("sort"));
			if(perv == null) return;
		}else{
			M next = getNext(qs, pid, list.get(0).getInt("sort"));
			if(next == null) return;
		}
		list.forEach(item -> {
			sort(qs, pid, opt, item);
		});
	}
	
	private void sort(Querys qs, String pid, String opt, M item){
		if(opt.equals("up")){
			M perv = getPerv(qs, pid, item.getInt("sort"));
			Integer pervSort = perv.getInt("sort");
			String pervPath = perv.get("path");
			Integer itemSort = item.getInt("sort");
			String itemPath = item.get("path");
			item.set("sort", pervSort);
			item.set("path", pervPath);
			perv.set("sort", itemSort);
			perv.set("path", itemPath);
			item.update();
			perv.update();
			
			Querys qsPerv = Querys.and().add(Query.like("path", pervPath + "_%"));
			Querys qsItem = Querys.and().add(Query.like("path", itemPath + "_%"));
			if(qs != null){
				qsPerv.add(qs);
				qsItem.add(qs);
			}
			List<M> listPerv = select(qsPerv);
			listPerv.forEach(d -> {
				d.set("path", d.getStr("path").replace(pervPath, itemPath));
			});
			List<M> listItem = select(qsItem);
			listItem.forEach(d -> {
				d.set("path", d.getStr("path").replace(itemPath, pervPath));
			});
			dbo().batchUpdate(listPerv, 100);
			dbo().batchUpdate(listItem, 100);
		}else{
			M next = getNext(qs, pid, item.getInt("sort"));
			Integer nextSort = next.getInt("sort");
			String nextPath = next.get("path");
			Integer itemSort = item.getInt("sort");
			String itemPath = item.get("path");
			item.set("sort", nextSort);
			item.set("path", nextPath);
			next.set("sort", itemSort);
			next.set("path", itemPath);
			item.update();
			next.update();
			
			Querys qsNext = Querys.and().add(Query.like("path", nextPath + "_%"));
			Querys qsItem = Querys.and().add(Query.like("path", itemPath + "_%"));
			if(qs != null){
				qsNext.add(qs);
				qsItem.add(qs);
			}
			List<M> listNext = select(qsNext);
			listNext.forEach(d -> {
				d.set("path", d.getStr("path").replace(nextPath, itemPath));
			});
			List<M> listItem = select(qsItem);
			listItem.forEach(d -> {
				d.set("path", d.getStr("path").replace(itemPath, nextPath));
			});
			dbo().batchUpdate(listNext, 1000);
			dbo().batchUpdate(listItem, 1000);
		}
	}
	
}
